/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcPurlistTieredQtyContinueValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        String tieredType = PdsCommonUtils.object2String((Object)context.getBillObj().getString("projectf7.tieredtype"), (String)"1");
        if ("1".equals(tieredType)) {
            return;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        int index = 0;
        StringBuilder message = new StringBuilder();
        String scoretype = PdsCommonUtils.object2String((Object)context.getBillObj().getString("projectf7.scoretype"), (String)"2");
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows;
            if ("2".equals(tieredType)) {
                if (index > 0 && row.getString("materialnane").equals(((DynamicObject)rows.get(index - 1)).getString("materialnane"))) {
                    if ("2".equals(scoretype) && "src_decision".equals(context.getView().getParentView().getModel().getDataEntityType().getName())) {
                        return;
                    }
                    message.append((CharSequence)this.veryfyRange(row, (DynamicObject)rows.get(index - 1), "qtyfrom", "qtyto", index, -1));
                }
            } else if ("3".equals(tieredType) && (subRows = row.getDynamicObjectCollection("subentryentity")).size() > 0) {
                int subIndex = 0;
                for (DynamicObject subRow : subRows) {
                    if (subIndex > 0) {
                        message.append((CharSequence)this.veryfyRange(subRow, (DynamicObject)subRows.get(subIndex - 1), "tieredqtyfrom", "tieredqtyto", index, subIndex));
                    }
                    ++subIndex;
                }
            }
            ++index;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }

    private StringBuilder veryfyRange(DynamicObject row, DynamicObject preRow, String qtyFromField, String qtyFromTo, int index, int subIndex) {
        StringBuilder sb = new StringBuilder();
        if ((row.getBigDecimal(qtyFromField).compareTo(BigDecimal.ZERO) > 0 || preRow.getBigDecimal(qtyFromTo).compareTo(BigDecimal.ZERO) > 0) && row.getBigDecimal(qtyFromField).compareTo(preRow.getBigDecimal(qtyFromTo)) != 0) {
            if (subIndex > 0) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u6807\u7684{0}-\u9636\u68af{1}\uff1a\u4e0a\u4e00\u884c\u7684\u201c\u9636\u68af\u6570\u91cf\u81f3\u201d \u5e94\u7b49\u4e8e \u672c\u884c\u7684\u201c\u9636\u68af\u6570\u91cf\u4ece\u201d\u3002", (String)"SrcPurlistTieredQtyContinueValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1, subIndex + 1));
            } else {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u6807\u7684{0}\uff1a\u4e0a\u4e00\u884c\u7684\u201c\u9636\u68af\u6570\u91cf\u81f3\u201d\u5e94\u7b49\u4e8e\u672c\u884c\u7684\u201c\u9636\u68af\u6570\u91cf\u4ece\u201d\u3002", (String)"SrcPurlistTieredQtyContinueValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1));
            }
            sb.append('\n');
        }
        return sb;
    }
}

