/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.util.SrcAppCache;

public class SrcPurlistVieMaxPriceValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        IFormView parentView = context.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (!Objects.equals(entityId, "src_project") && !Objects.equals(entityId, "src_purlist")) {
            return;
        }
        String viePageId = (String)SrcAppCache.get((String)"vierulepageid", String.class, (IFormView)parentView);
        if (StringUtils.isEmpty((CharSequence)viePageId)) {
            return;
        }
        if (null == context.getView().getView(viePageId)) {
            return;
        }
        String viePattern = context.getView().getView(viePageId).getModel().getDataEntity().getString("viepattern");
        if (StringUtils.isBlank((CharSequence)viePattern)) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u7ade\u4ef7\u89c4\u5219\u4e2d\u8bbe\u7f6e\u7ade\u4ef7\u6a21\u5f0f\u3002", (String)"SrcPurlistVieMaxPriceValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!viePattern.equals("2") && !viePattern.equals("3")) {
            return;
        }
        String basePageId = (String)SrcAppCache.get((String)"baseinfopageid", String.class, (IFormView)parentView);
        if (StringUtils.isEmpty((CharSequence)basePageId)) {
            return;
        }
        String taxType = context.getView().getView(basePageId).getModel().getDataEntity().getString("taxtype");
        String decisionType = context.getView().getView(basePageId).getModel().getDataEntity().getString("decisiontype");
        Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)taxType);
        Map maxPriceFieldMap = PdsVieHelper.getMaxPriceField((String)decisionType, (String)taxType);
        String maxPriceField = (String)maxPriceFieldMap.get("fieldid");
        String fieldName = (String)maxPriceFieldMap.get("fieldname");
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            int i = 1;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : rows) {
                if (row.getBigDecimal(maxPriceField).compareTo(BigDecimal.ZERO) <= 0) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c, {1} \u65f6\uff0c{2} \u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcPurlistVieMaxPriceValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), i, viePatternTitleMap.get("viepattern"), fieldName));
                    sb.append('\n');
                }
                ++i;
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                context.setSucced(false);
                context.setMessage(sb.toString());
            }
        }
    }
}

