/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcProjectUtil;
import kd.scm.src.opplugin.validator.SrcSupplierAccountValidator;

public class SrcSelectSupplierAccountValidator
extends SrcSupplierAccountValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("parentid");
        propertys.add("entrysupplier");
        propertys.add("entrysupplier.supplier");
        propertys.add("entrysupplier.supname");
        propertys.add("entrysupplier.ispuragent");
        propertys.add("entrysupplier.isinvite");
        propertys.add("entrysupplier.supplieruser");
        return propertys;
    }

    public void validate(SrcValidatorData validatorData) {
        StringBuilder sb = new StringBuilder();
        String parentId = validatorData.getBillObj().getString("parentid");
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(parentId));
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((String)"src_project", (String)"id,sourceclass", (QFilter[])filter.toArray());
        if (SrcProjectUtil.isQuickPur((DynamicObject)projectObj)) {
            return;
        }
        DynamicObjectCollection supplierRows = validatorData.getBillObj().getDynamicObjectCollection("entrysupplier");
        if (supplierRows.size() == 0) {
            return;
        }
        HashMap<Long, DynamicObject> supplierIdMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject supRow : supplierRows) {
            DynamicObject supplier;
            boolean isinvite;
            boolean ispuragent = supRow.getBoolean("ispuragent");
            if (ispuragent || !(isinvite = supRow.getBoolean("isinvite")) || null == (supplier = supRow.getDynamicObject("supplier"))) continue;
            supplierIdMap.put(supplier.getLong("id"), supplier);
        }
        if (supplierIdMap.size() > 0) {
            Map bizpartnerIDSupMap = SupplierUtil.getNoAccountSupplier(supplierIdMap);
            sb.append(this.getUnAccountMsg(bizpartnerIDSupMap));
        }
        if (sb.length() > 0) {
            validatorData.setMessage(sb.toString());
            validatorData.setSucced(false);
        }
    }
}

