/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieRulePurlistValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        Long projectId = billObj.getLong("id");
        QFilter purlistFilter = new QFilter("id", "=", (Object)projectId);
        purlistFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        boolean isAudidt = QueryServiceHelper.exists((String)"src_purlist", (QFilter[])purlistFilter.toArray());
        if (!isAudidt) {
            return;
        }
        String viePattern = billObj.getString("viepattern");
        if (StringUtils.isBlank((CharSequence)viePattern)) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u7ade\u4ef7\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5230\u7ade\u4ef7\u89c4\u5219\u4e2d\u8bbe\u7f6e\u7ade\u4ef7\u6a21\u5f0f\u3002", (String)"SrcVieRulePurlistValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!viePattern.equals("2") && !viePattern.equals("3")) {
            return;
        }
        String pentitykey = billObj.getString("pentitykey");
        if (!Objects.equals(pentitykey, "src_project")) {
            return;
        }
        DynamicObject purlistObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_purlist");
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)purlistObj, (boolean)false);
        for (String compKey : compKeyList) {
            DynamicObject compObj = TemplateUtil.getComponentData((Object)billObj.getLong("id"), (String)"src_purlist", (String)compKey);
            String taxType = compObj.getString("taxtype");
            String decisionType = compObj.getString("decisiontype");
            Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)taxType);
            Map maxPriceFieldMap = PdsVieHelper.getMaxPriceField((String)decisionType, (String)taxType);
            String maxPriceField = (String)maxPriceFieldMap.get("fieldid");
            String fieldName = (String)maxPriceFieldMap.get("fieldname");
            DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)rows)) continue;
            int i = 1;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : rows) {
                if (row.getBigDecimal(maxPriceField).compareTo(BigDecimal.ZERO) <= 0) {
                    if (sb.length() == 0) {
                        String showTitle = PdsCommonUtils.getShowCompTitle((String)"src_purlist", (String)compKey, (DynamicObject)PdsCommonUtils.getCompRegData((String)"src_purlist", (String)compKey));
                        sb.append(showTitle).append('\n');
                    }
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c,{1}\u65f6\uff0c{2}\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcVieRulePurlistValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), i, viePatternTitleMap.get("viepattern"), fieldName));
                    sb.append('\n');
                }
                ++i;
            }
            if (!StringUtils.isNotBlank((CharSequence)sb.toString())) continue;
            this.getUnSuccedResult(context, sb.toString());
            return;
        }
    }
}

