/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcWinRuleRatioHendredValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        String ratioType;
        DynamicObject billObj = context.getBillObj();
        String fieldName = "ratiotype";
        if (billObj.getDataEntityType().getName().equals("src_ratiotypechg")) {
            fieldName = "newratiotype";
        }
        if ("1".equals(ratioType = PdsCommonUtils.object2String((Object)billObj.get(fieldName), (String)"1")) || "9".equals(ratioType)) {
            return;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u4efd\u989d\u5206\u914d\u6bd4\u7387\u7684\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"SrcWinRuleRatioHendredValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)rows, (String)"project", (String)"package", (String)"purlist");
        if (!((Boolean)resultMap.get("succed")).booleanValue()) {
            this.getUnSuccedResult(context, resultMap.get("message").toString());
            return;
        }
        BigDecimal hendred = new BigDecimal(100);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            if (((DynamicObject)rows.get(i)).getBigDecimal("orderratio").compareTo(hendred) != 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u4efd\u989d\u4e4b\u548c\u9700\u7b49\u4e8e100\u3002", (String)"SrcWinRuleRatioHendredValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), i + 1)).append("\n");
                continue;
            }
            for (int j = 1; j < 10; ++j) {
                if (((DynamicObject)rows.get(i)).getBigDecimal("orderratio" + SrcWinruleUtils.formatInt((int)j, (boolean)true)).compareTo(((DynamicObject)rows.get(i)).getBigDecimal("orderratio" + SrcWinruleUtils.formatInt((int)(j + 1), (boolean)true))) >= 0) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7b2c%2$s\u540d\u7684\u4efd\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b2c%3$s\u540d\u7684\u4efd\u989d\u3002", (String)"SrcWinRuleRatioHendredValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), i + 1, j, j + 1)).append("\n");
            }
        }
        if (sb.length() > 0) {
            this.getUnSuccedResult(context, sb.toString());
        }
    }
}

