/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcPayMenthandlePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map dataMap = parameter.getCustomParams();
        if (null == dataMap) {
            return;
        }
        String opKey = (String)dataMap.get("opkey");
        this.setDefaultValue(dataMap);
        this.setControlByOpKey(opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (!this.dataVerify(opKey)) {
            args.setCancel(true);
            return;
        }
        if (!this.verifyPayStatus()) {
            args.setCancel(true);
            return;
        }
        switch (opKey) {
            case "confirm": 
            case "reject": 
            case "exempt": 
            case "return": 
            case "transfer": 
            case "carryover": {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Map dataMap = parameter.getCustomParams();
                if (null == dataMap) {
                    return;
                }
                String cfmOpinion = this.getModel().getDataEntity().getString("cfmopinion");
                if (StringUtils.isEmpty((String)cfmOpinion)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPayMenthandlePlugin_0", (String)"scm-src-formplugin", (Object[])new Object[0]), this.getOpTitle(opKey)));
                    args.setCancel(true);
                    return;
                }
                dataMap.put("cfmopinion", cfmOpinion);
                dataMap.put("cfm", this.getModel().getDataEntity().getLong("cfm.id"));
                dataMap.put("cfmdate", this.getModel().getValue("cfmdate"));
                dataMap.put("returnamount", this.getModel().getValue("returnamount"));
                dataMap.put("transferamount", this.getModel().getValue("transferamount"));
                dataMap.put("carryoveramount", this.getModel().getValue("carryoveramount"));
                dataMap.put("surplustype", "2");
                DynamicObjectCollection attachRows = this.getModel().getDataEntity().getDynamicObjectCollection("voucher2");
                AttachmentUtils.convertTempAttachments((DynamicObjectCollection)attachRows);
                String fieldName = "fbasedataid.id";
                Set bdSet = attachRows.stream().filter(e -> e.getLong(fieldName) > 0L).map(e -> e.getLong(fieldName)).collect(Collectors.toSet());
                dataMap.put("voucher2", bdSet);
                try (TXHandle tx = TX.requiresNew();){
                    FeeManageUtils.updatePaymentStatus((Map)dataMap);
                }
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private boolean verifyPayStatus() {
        DynamicObject paymentObj;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map dataMap = parameter.getCustomParams();
        if (null == dataMap) {
            return false;
        }
        String opKey = (String)dataMap.get("opkey");
        return FeeManageUtils.verifyPayStatus((String)opKey, (DynamicObject)(paymentObj = BusinessDataServiceHelper.loadSingle((Object)PdsCommonUtils.object2Long(dataMap.get("entryid")), (String)"src_payment")), (IFormView)this.getView());
    }

    private boolean dataVerify(String opKey) {
        BigDecimal usesurplus = this.getModel().getDataEntity().getBigDecimal("usesurplus");
        BigDecimal payamount = this.getModel().getDataEntity().getBigDecimal("payamount");
        switch (opKey) {
            case "return": {
                BigDecimal returnamount = this.getModel().getDataEntity().getBigDecimal("returnamount");
                if (returnamount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9000\u8fd8\u91d1\u989d\u3002", (String)"SrcPayMenthandlePlugin_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (returnamount.compareTo(payamount.add(usesurplus)) <= 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9000\u8fd8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5b9e\u6536\u91d1\u989d+\u672c\u6b21\u4f7f\u7528\u4f59\u989d\u3002", (String)"SrcPayMenthandlePlugin_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "transfer": {
                BigDecimal transferamount = this.getModel().getDataEntity().getBigDecimal("transferamount");
                if (transferamount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u4f59\u91d1\u989d\u3002", (String)"SrcPayMenthandlePlugin_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (transferamount.compareTo(payamount.add(usesurplus)) <= 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u4f59\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5b9e\u6536\u91d1\u989d+\u672c\u6b21\u4f7f\u7528\u4f59\u989d\u3002", (String)"SrcPayMenthandlePlugin_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "carryover": {
                BigDecimal carryamount = this.getModel().getDataEntity().getBigDecimal("carryoveramount");
                if (carryamount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8f6c\u5c65\u7ea6\u91d1\u989d\u3002", (String)"SrcPayMenthandlePlugin_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (carryamount.compareTo(payamount.add(usesurplus)) <= 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u5c65\u7ea6\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5b9e\u6536\u91d1\u989d+\u672c\u6b21\u4f7f\u7528\u4f59\u989d\u3002", (String)"SrcPayMenthandlePlugin_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void setDefaultValue(Map<String, Object> dataMap) {
        Object payAmount;
        List attachIds;
        this.getModel().setValue("opkey", dataMap.get("opkey"));
        this.getModel().setValue("cfm", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("amount", dataMap.get("amount"));
        this.getModel().setValue("payamount", dataMap.get("payamount"));
        this.getModel().setValue("paydate", dataMap.get("paydate"));
        this.getModel().setValue("suppliertype", dataMap.get("suppliertype"));
        this.getModel().setValue("supplier", dataMap.get("supplier"));
        this.getModel().setValue("currency", dataMap.get("currency"));
        BigDecimal usesurplus = PdsCommonUtils.object2BigDecimal((Object)dataMap.get("usesurplus"));
        this.getModel().setValue("usesurplus", (Object)usesurplus);
        this.getModel().setValue("feeamount", dataMap.get("feeamount"));
        if (null != dataMap.get("voucher")) {
            attachIds = (List)dataMap.get("voucher");
            MultiBasedataUtils.setMultiBasedataForModel((IDataModel)this.getModel(), attachIds.stream().collect(Collectors.toSet()), (String)"voucher");
        }
        if (null != dataMap.get("voucher2")) {
            attachIds = (List)dataMap.get("voucher2");
            MultiBasedataUtils.setMultiBasedataForModel((IDataModel)this.getModel(), attachIds.stream().collect(Collectors.toSet()), (String)"voucher2");
        }
        if (null == (payAmount = dataMap.get("payamount"))) {
            return;
        }
        BigDecimal amount = ((BigDecimal)payAmount).add(usesurplus);
        this.getModel().setValue("returnamount", (Object)amount);
        this.getModel().setValue("transferamount", (Object)amount);
        this.getModel().setValue("carryoveramount", (Object)amount);
    }

    private void setControlByOpKey(String opKey) {
        if (null == opKey) {
            return;
        }
        UserEdit cfm = (UserEdit)this.getView().getControl("cfm");
        DateTimeEdit cfmdate = (DateTimeEdit)this.getView().getControl("cfmdate");
        TextEdit cfmopinion = (TextEdit)this.getView().getControl("cfmopinion");
        DecimalEdit returnamt = (DecimalEdit)this.getView().getControl("returnamount");
        DecimalEdit transferamt = (DecimalEdit)this.getView().getControl("transferamount");
        DecimalEdit carryamount = (DecimalEdit)this.getView().getControl("carryoveramount");
        this.getView().setVisible(Boolean.FALSE, new String[]{"returnamount", "transferamount", "carryoveramount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm", "bar_reject", "bar_exempt", "bar_return", "bar_transfer", "bar_carryover"});
        switch (opKey) {
            case "confirm": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_confirm"});
                break;
            }
            case "reject": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_reject"});
                break;
            }
            case "exempt": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_exempt"});
                break;
            }
            case "return": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_return"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"returnamount"});
                returnamt.setMustInput(true);
                break;
            }
            case "transfer": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_transfer"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"transferamount"});
                transferamt.setMustInput(true);
                break;
            }
            case "carryover": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_carryover"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"carryoveramount"});
                carryamount.setMustInput(true);
                break;
            }
        }
        String opTitle = this.getOpTitle(opKey);
        LocaleString localUser = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u4eba", (String)"SrcPayMenthandlePlugin_7", (String)"scm-src-formplugin", (Object[])new Object[0]), opTitle));
        LocaleString localDate = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u65f6\u95f4", (String)"SrcPayMenthandlePlugin_8", (String)"scm-src-formplugin", (Object[])new Object[0]), opTitle));
        LocaleString localOpinion = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u610f\u89c1", (String)"SrcPayMenthandlePlugin_9", (String)"scm-src-formplugin", (Object[])new Object[0]), opTitle));
        cfm.setCaption(localUser);
        cfmdate.setCaption(localDate);
        cfmopinion.setCaption(localOpinion);
    }

    private String getOpTitle(String operation) {
        String opTitle = "";
        switch (operation) {
            case "confirm": {
                opTitle = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"SrcPayMenthandlePlugin_10", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
            case "reject": {
                opTitle = ResManager.loadKDString((String)"\u6253\u56de", (String)"SrcPayMenthandlePlugin_11", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
            case "exempt": {
                opTitle = ResManager.loadKDString((String)"\u514d\u4ea4", (String)"SrcPayMenthandlePlugin_12", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
            case "return": {
                opTitle = ResManager.loadKDString((String)"\u9000\u8fd8", (String)"SrcPayMenthandlePlugin_13", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
            case "transfer": {
                opTitle = ResManager.loadKDString((String)"\u7ed3\u4f59", (String)"SrcPayMenthandlePlugin_14", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
            case "carryover": {
                opTitle = ResManager.loadKDString((String)"\u8f6c\u5c65\u7ea6", (String)"SrcPayMenthandlePlugin_15", (String)"scm-src-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return opTitle;
    }
}

