/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.BizLog;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.LowTimer;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.common.util.SrcQuickPurUtil;
import org.apache.commons.lang3.StringUtils;

public class SrcPurlistAttributeSetPlugin
extends AbstractBillPlugIn {
    private String[] propertiesStr;

    private void setParentViewValue(IFormView view, String property, String parentProperty) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        Object object = parentView.getModel().getValue(parentProperty);
        if (object instanceof DynamicObject) {
            this.getView().getModel().setValue(property, object);
        } else if (StringUtils.isNotEmpty((CharSequence)String.valueOf(object))) {
            this.getView().getModel().setValue(property, object);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String origin = (String)this.getModel().getValue("origin");
        if (null == origin) {
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LowTimer timer = new LowTimer();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String origin = (String)this.getModel().getValue("origin");
        if (null == origin) {
            return;
        }
        switch (origin) {
            case "1": {
                if ("src_purlist".equals(parentView.getEntityId()) || "src_project".equals(parentView.getEntityId()) || "src_predecision".equals(parentView.getEntityId())) {
                    SrcPurListUtil.setBidMaterialDisplay((IFormView)this.getView());
                    if (Objects.equals(parentView.getModel().getDataEntity().getString("billstatus"), SrcProjectEnum.STAGING.getCode())) {
                        this.setParentViewValue(this.getView(), "curr", "currency");
                        this.setParentViewValue(this.getView(), "decisiontype", "decisiontype");
                        this.setParentViewValue(this.getView(), "taxtype", "taxtype");
                    }
                }
                if (!SrcQuickPurUtil.isQuickPurchase((IFormView)this.getView(), Collections.singletonList("src_decision")) || !Objects.equals(parentView.getModel().getDataEntity().getString("billstatus"), SrcProjectEnum.STAGING.getCode())) break;
                this.setParentViewValue(this.getView(), "decisiontype", "decisiontype");
                this.setParentViewValue(this.getView(), "taxtype", "taxtype");
                this.setParentViewValue(this.getView(), "managetype", "managetype");
                break;
            }
            case "2": {
                BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
                BillOperationStatus billStatus = showParameter.getBillStatus();
                if (BillOperationStatus.SUBMIT.equals((Object)billStatus) || BillOperationStatus.AUDIT.equals((Object)billStatus)) break;
                this.lockIsDiscarded();
                break;
            }
            case "3": {
                break;
            }
        }
        String taxType = this.getModel().getDataEntity().getString("taxtype");
        String decisionType = this.getModel().getDataEntity().getString("decisiontype");
        this.setPriceProByTaxType(taxType, decisionType, false);
        this.getModel().setDataChanged(false);
        BizLog.log((String)("###SrcPurlistAttributeSetPlugin afterbinddata costtime:" + timer.msValue()));
    }

    public void setPriceProByTaxType(String taxType, String decisionType, boolean isChange) {
        PdsCommonUtils.setPriceProByTaxType((String)taxType, (String)decisionType, (IFormView)this.getView(), (boolean)false, (boolean)isChange);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "isdiscarded": {
                this.lockField(newValue, rowIndex, "isdiscarded");
                break;
            }
            case "bidmaterial": {
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("material", null, rowIndex);
                    this.getModel().setValue("materialnane", null, rowIndex);
                    this.getModel().setValue("category", null, rowIndex);
                }
            }
            case "suppliertype": {
                this.getModel().setValue("supplier", null, rowIndex);
                this.getModel().setValue("suppliername", null, rowIndex);
                break;
            }
            case "supplier": {
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("suppliername", null, rowIndex);
                    break;
                }
                this.getModel().setValue("suppliername", (Object)((DynamicObject)newValue).getString("name"), rowIndex);
                break;
            }
            case "material": 
            case "category": 
            case "unit": 
            case "currency": {
                this.getModel().setValue("costdetail", (Object)"0", rowIndex);
                break;
            }
            case "decisiontype": {
                String taxType = this.getModel().getDataEntity().getString("taxtype");
                this.setPriceProByTaxType(taxType, String.valueOf(newValue), true);
                break;
            }
            case "taxtype": {
                String decisionType = this.getModel().getDataEntity().getString("decisiontype");
                this.setPriceProByTaxType(String.valueOf(newValue), decisionType, true);
                break;
            }
        }
    }

    private void lockField(Object newValue, int rowIndex, String lockFieldType) {
        String[] propertiesStr = this.getLockPropertiesStr(lockFieldType);
        if (((Boolean)newValue).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, propertiesStr);
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, propertiesStr);
        }
    }

    private String[] getLockPropertiesStr(String lockFieldType) {
        if (null != this.propertiesStr) {
            return this.propertiesStr;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        if (Objects.equals(lockFieldType, "isdiscarded")) {
            properties.remove("isdiscarded");
        }
        this.propertiesStr = properties.toArray(new String[0]);
        return this.propertiesStr;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("hyperclickclosecalback".equals(actionId)) {
            this.lockIsDiscarded();
        }
    }

    private void lockIsDiscarded() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < rows.size(); ++i) {
            boolean isDiscard = ((DynamicObject)rows.get(i)).getBoolean("isdiscardbid");
            String entryStatus = ((DynamicObject)rows.get(i)).getString("entrystatus");
            if (Objects.equals(entryStatus, ProjectStatusEnums.INVALID.getValue())) {
                this.lockField(true, i, ProjectStatusEnums.INVALID.getValue());
                continue;
            }
            if (isDiscard) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"isdiscarded"});
                boolean isDiscarded = ((DynamicObject)rows.get(i)).getBoolean("isdiscarded");
                if (!isDiscarded) continue;
                this.lockField(true, i, "isdiscarded");
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"isdiscarded"});
        }
    }
}

