/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.pds.common.edit.AbstractBillImportEdit;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.enums.SrcPropertyEnum;
import kd.scm.src.common.enums.SrcScoreMethodEnum;
import kd.scm.src.common.enums.SrcScoreTypeEnum;
import kd.scm.src.common.enums.SrcVetoEnum;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

public class SrcScoreExportEdit
extends AbstractBillImportEdit {
    protected void addUniqueColumn(List<String> uniqueColumnList) {
        super.addUniqueColumn(uniqueColumnList);
        uniqueColumnList.add("detailid");
    }

    protected String getBdPro(String column) {
        if (Objects.equals(column, "index")) {
            return "INDEX_DEFAULT";
        }
        return super.getBdPro(column);
    }

    protected void setColumn(ExcelDataEntity excelDataEntity) {
        super.setColumn(excelDataEntity);
        ArrayList<String> columnKeys = new ArrayList<String>(excelDataEntity.getColumnKeyList());
        columnKeys.add("detailid");
        excelDataEntity.setColumnKeyList(columnKeys);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        if (null != toolBar) {
            toolBar.addUploadListener((UploadListener)this);
        }
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        switch (column) {
            case "note": {
                if (Objects.isNull(val)) {
                    return null;
                }
                String note = val.toString();
                if (note.length() > 255) {
                    IDataEntityProperty pro = this.findPro(column);
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u5b57\u8282\u3002", (String)"SrcScoreExportEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), pro.getDisplayName()));
                    msg.append('\n');
                    return null;
                }
                return super.getVal(column, index, val, msg);
            }
            case "value": 
            case "detailid": {
                return super.getVal(column, index, val, msg);
            }
        }
        return null;
    }

    protected boolean isAddNew() {
        return false;
    }

    protected boolean isImport(boolean isUpdate, Integer updateRowIndex, StringBuilder rowMsg, Map<String, Object> importDataMap) {
        DynamicObject row;
        if (Objects.isNull(updateRowIndex)) {
            return false;
        }
        if (isUpdate && Objects.equals((row = this.getModel().getEntryRowEntity("score_entry", updateRowIndex.intValue())).getString("detailid"), String.valueOf(importDataMap.get("detailid")))) {
            if (Objects.equals(SrmScoreStatusEnum.SCORED.getValue(), row.getString("bizstatus"))) {
                rowMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4e3a\u5df2\u8bc4\u6807\uff0c\u4e0d\u80fd\u5bfc\u5165%1$s\u3002", (String)"SrcScoreExportEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]), "\n"));
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        HashMap<String, String> mustInputProMap = new HashMap<String, String>(8);
        mustInputProMap.put("score_entry.value", ResManager.loadKDString((String)"\u8bc4\u5206\u5206\u5f55.\u8bc4\u4f30\u503c", (String)"SrcScoreExportEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
        ArrayList<String> columnTitleList = new ArrayList<String>();
        Integer rowCount = 0;
        ArrayList<Integer> mustInputIndexList = new ArrayList<Integer>();
        Map proMap = PdsMetadataUtil.getProMap((String)excelDataEntity.getEntityKey(), (boolean)false);
        proMap.put("score_entry.detailid", ResManager.loadKDString((String)"\u8bc4\u5206\u5206\u5f55.\u660e\u7ec6ID", (String)"SrcScoreExportEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
        for (int i = 0; i < excelDataEntity.getColumnKeyList().size(); ++i) {
            String column = (String)excelDataEntity.getColumnKeyList().get(i);
            String proName = proMap.getOrDefault(excelDataEntity.getEntryKey() + "." + column, ResManager.loadKDString((String)".\u672a\u5b9a\u4e49", (String)"SrcScoreExportEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
            if (StringUtils.isBlank((String)proName)) continue;
            StringBuilder headTitileSb = new StringBuilder();
            String configKey = this.getEntryKey() + "." + column;
            if (null != mustInputProMap.get(configKey)) {
                headTitileSb.append('*');
                mustInputIndexList.add(rowCount);
            } else if ("detailid".equals(column)) {
                headTitileSb.append(ResManager.loadKDString((String)"*(\u52ff\u6539\u52ff\u5220)", (String)"SrcScoreExportEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
                mustInputIndexList.add(rowCount);
            }
            String[] proNames = proName.split("\\.");
            headTitileSb.append(proNames[1]);
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                headTitileSb.append("${");
                headTitileSb.append(column);
                headTitileSb.append('}');
            }
            columnTitleList.add(headTitileSb.toString());
            Integer n = rowCount;
            Integer n2 = rowCount = Integer.valueOf(rowCount + 1);
        }
        excelDataEntity.setExcelHeader(columnTitleList);
        this.setColumnTitleColor(excelDataEntity, mustInputIndexList);
    }

    protected void setColumnTitleColor(ExcelDataEntity excelDataEntity, List<Integer> mustInputIndexList) {
        CellStyle style = this.getCellStyle(excelDataEntity);
        for (int colIndex : mustInputIndexList) {
            if (colIndex <= 0) continue;
            try {
                excelDataEntity.setStyle(0, 0, colIndex, style, 4000);
            }
            catch (IOException e) {
                BizLog.log((String)e.getMessage());
            }
        }
    }

    protected CellStyle getCellStyle(ExcelDataEntity excelDataEntity) {
        CellStyle style = excelDataEntity.getWorkbook().createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.GENERAL);
        Font font = excelDataEntity.getWorkbook().createFont();
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        return style;
    }

    private BigDecimal setScale(BigDecimal columnVal, String column) {
        if (columnVal.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return columnVal.setScale(this.getScale(column), RoundingMode.HALF_UP);
    }

    protected int getScale(String column) {
        int scale;
        switch (column) {
            case "score": 
            case "scorerscore": 
            case "sysscore": {
                scale = 4;
                break;
            }
            case "indexweight": 
            case "threshold": 
            case "scorerweight": {
                scale = 2;
                break;
            }
            default: {
                scale = 6;
            }
        }
        return scale;
    }

    public Object getRowVal(DynamicObject col, String column, int index) {
        Object val = "";
        Object columnVal = null;
        if ("project".equals(column)) {
            DynamicObject project = col.getDynamicObject(column);
            if (project != null) {
                val = project.get("bidname");
            }
        } else if ("indextype".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (null == indexObj) {
                return "";
            }
            val = indexObj.getString("indextype.name");
        } else if ("index".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject(column);
            if (indexObj != null) {
                val = indexObj.get("index");
            }
        } else if ("scoremethod".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = SrcScoreMethodEnum.getMessageByCode((String)indexObj.getString("scoremethod"));
            }
        } else if ("indexscore".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = indexObj.getBigDecimal("score").stripTrailingZeros().toPlainString();
            }
        } else if ("property".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = SrcPropertyEnum.getMessageByCode((String)indexObj.getString("property"));
            }
        } else if ("scoretype".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = SrcScoreTypeEnum.getMessageByCode((String)indexObj.getString("scoretype"));
            }
        } else if ("isdeduct".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = indexObj.getBoolean("isdeduct") ? ResManager.loadKDString((String)"\u662f", (String)"SrcScoreExportEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcScoreExportEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]);
            }
        } else if ("indexclass".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null) {
                val = indexObj.getString("indextype.name");
            }
        } else if ("lowvalue".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null && BigDecimal.ZERO.compareTo((BigDecimal)(val = indexObj.getBigDecimal("lowvalue"))) == 0) {
                val = BigDecimal.ZERO;
            }
        } else if ("hightvalue".equals(column)) {
            DynamicObject indexObj = col.getDynamicObject("index");
            if (indexObj != null && BigDecimal.ZERO.compareTo((BigDecimal)(val = indexObj.getBigDecimal("hightvalue"))) == 0) {
                val = BigDecimal.ZERO;
            }
        } else {
            try {
                columnVal = col.get(column);
            }
            catch (Exception e) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u503c\u5931\u8d25\uff1a%1$s\u3002", (String)"SrcScoreExportEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (Objects.nonNull(columnVal)) {
                if (columnVal instanceof DynamicObject) {
                    if (column.equals("package")) {
                        val = ((DynamicObject)columnVal).get("packagename");
                    } else if ("supplier".equals(column)) {
                        val = ((DynamicObject)columnVal).get("name");
                    }
                } else {
                    val = columnVal instanceof BigDecimal ? this.setScale((BigDecimal)columnVal, column) : (columnVal instanceof Boolean ? (((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"SrcScoreExportEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcScoreExportEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0])) : (Objects.equals("scorerveto", column) ? SrcVetoEnum.getMessageByCode((String)columnVal.toString()) : (Objects.equals("bizstatus", column) ? SrmScoreStatusEnum.fromVal((String)columnVal.toString()).getName() : columnVal)));
                }
            }
        }
        return val;
    }

    protected String getEntryKey() {
        return "score_entry";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        args.setCancel(true);
        switch (opKey) {
            case "export": {
                this.exportData();
                break;
            }
        }
    }
}

