/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcToDemandPushDownPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs evt) {
        ExtendedDataEntitySet entitySet = evt.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("src_demand");
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject demandObj = entity.getDataEntity();
            this.setPushDefaultValue(demandObj);
        }
    }

    public void setPushDefaultValue(DynamicObject demandObj) {
        DynamicObjectCollection rows = demandObj.getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        Set srcBillIds = rows.stream().map(e -> e.getString("srcbillid")).collect(Collectors.toSet());
        Set srcEntryIds = rows.stream().map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_detail", (boolean)false);
        DynamicObject[] applyRows = BusinessDataServiceHelper.load((String)"src_detail", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", srcEntryIds)});
        Map<String, List<DynamicObject>> applyMap = Arrays.asList(applyRows).stream().collect(Collectors.groupingBy(e -> e.getString("id")));
        AttachmentUtils.cloneAttachments((String)"src_apply", srcBillIds, (String)"src_demand", (DynamicObject)demandObj, null);
        for (DynamicObject row : rows) {
            String srcentryId = row.getString("srcentryid");
            List<DynamicObject> applyObjs = applyMap.get(srcentryId);
            if (null == applyObjs || applyObjs.size() <= 0) continue;
            row.set("purlistentry_fj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)applyObjs.get(0), (String)"purlistentry_fj"));
        }
    }
}

