/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.bidchange;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcDecisionPurlistEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private boolean isChanging = false;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setPackageVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        QFilter qfilter = null;
        switch (proName = e.getProperty().getName()) {
            case "package": {
                if (this.isChanging) break;
                Set packageIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getDataEntity(), (String)"package");
                qfilter = this.getValidPurlistFilter().and("package", "in", (Object)packageIds);
                this.isChanging = true;
                this.getModel().setValue("purlist", null);
                this.isChanging = false;
                break;
            }
            case "purlist": {
                if (this.isChanging) break;
                Set purlistIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getDataEntity(), (String)"purlist");
                qfilter = this.getValidPurlistFilter().and("purlist", "in", (Object)purlistIds);
                this.isChanging = true;
                this.getModel().setValue("package", null);
                this.isChanging = false;
                break;
            }
        }
        if (null != qfilter) {
            String orderBy = "packagename,materialnane,rank,turns";
            TemplateUtil.loadCompEntryData((IFormView)this.getView(), (String)"src_purlistf7", qfilter, this.getExcFields(), (String)"entryentity", (String)orderBy, (boolean)false);
        }
    }

    private Set<String> getExcFields() {
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("seq");
        excFields.add("packagename");
        for (int i = 1; i <= 20; ++i) {
            if (i < 10) {
                excFields.add("property0" + i);
                continue;
            }
            excFields.add("property" + i);
        }
        return excFields;
    }

    public void registerListener(EventObject e) {
        BasedataEdit purlistControl;
        super.registerListener(e);
        BasedataEdit packageControl = (BasedataEdit)this.getView().getControl("package");
        if (null != packageControl) {
            packageControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purlistControl = (BasedataEdit)this.getView().getControl("purlist"))) {
            purlistControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName;
        switch (propertyName = evt.getProperty().getName()) {
            case "package": {
                QFilter packageFilter = new QFilter("id", "in", this.getValidPackageIds());
                evt.getCustomQFilters().add(packageFilter);
                break;
            }
            case "purlist": {
                QFilter purlistFilter = new QFilter("id", "in", this.getValidPurlistIds());
                evt.getCustomQFilters().add(purlistFilter);
                break;
            }
        }
    }

    private void setPackageVisible() {
        if (this.isMultipackage()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"package", "packagename"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"package", "packagename"});
        }
    }

    private boolean isMultipackage() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return false;
        }
        DynamicObject bidChangeObj = parentView.getModel().getDataEntity();
        return bidChangeObj.getBoolean("project.ismultipackage");
    }

    private QFilter getValidPurlistFilter() {
        DynamicObject bidChangeObj = this.getView().getParentView().getModel().getDataEntity();
        QFilter qfilter = new QFilter("project", "=", (Object)bidChangeObj.getLong("project.id"));
        qfilter.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        qfilter.and("rank", ">", (Object)0);
        qfilter.and("isdecision", "=", (Object)"0");
        return qfilter;
    }

    private Set<Long> getValidPurlistIds() {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])this.getValidPurlistFilter().toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
    }

    private Set<Long> getValidPackageIds() {
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id", (QFilter[])this.getValidPurlistFilter().toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
    }
}

