/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.bidchange;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcInviteSupplierChgEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private boolean isPuragentChange = false;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (null == parentView) {
            return;
        }
        this.setPackageVisible();
        this.setInviteSupplierVisible();
        if (this.getSupplierId() > 0L) {
            this.getModel().setValue("issupplier", (Object)true);
        } else {
            this.getModel().setValue("issupplier", (Object)false);
        }
    }

    private void setInviteSupplierVisible() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (Objects.equals(entityId, "tnd_bidchange")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invitesupplier"});
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String fieldKey = evt.getProperty().getName();
        int currIndex = evt.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "package": {
                if (this.getSupplierId() <= 0L) break;
                this.getModel().setValue("supplier", (Object)this.getSupplierId(), evt.getChangeSet()[0].getRowIndex());
                break;
            }
            case "supplier": {
                SupplierUtil.supplierChangedHandle((IDataModel)this.getModel(), (PropertyChangedArgs)evt);
                this.resetPurAgentValues(currIndex, "ispuragent", "isfeeagent", "ispuraptitude");
                this.getModel().setValue("supplieruser", null, evt.getChangeSet()[0].getRowIndex());
                break;
            }
            case "ispuragent": {
                this.resetPurAgentValues(currIndex, "ispuragent", null, null);
                break;
            }
            case "isfeeagent": {
                this.resetPurAgentValues(currIndex, null, "isfeeagent", null);
                break;
            }
            case "ispuraptitude": {
                this.resetPurAgentValues(currIndex, null, null, "ispuraptitude");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                this.deleteInvalidRows();
                Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entrysupplier"), (String)"package", (String)"supplier", null);
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                evt.setCancel(true);
                evt.setCancelMessage(resultMap.get("message").toString());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit supplierUserEdit;
        BasedataEdit supplierControl;
        super.registerListener(e);
        BasedataEdit packageControl = (BasedataEdit)this.getView().getControl("package");
        if (null != packageControl) {
            packageControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierControl = (BasedataEdit)this.getView().getControl("supplier"))) {
            supplierControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierUserEdit = (BasedataEdit)this.getView().getControl("supplieruser"))) {
            supplierUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String propertyName = evt.getProperty().getName();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("project"));
        int currIndex = this.getModel().getEntryCurrentRowIndex("entrysupplier");
        if (projectId == 0L) {
            return;
        }
        DynamicObject billObj = this.getView().getModel().getDataEntity();
        DynamicObject pBillObj = this.getView().getParentView().getModel().getDataEntity();
        switch (propertyName) {
            case "package": {
                QFilter packageFilter = new QFilter("project", "=", (Object)projectId);
                if (this.getSupplierId() > 0L) {
                    packageFilter.and("id", "not in", (Object)SupplierUtil.getInvitePackageIds((long)projectId, (long)this.getSupplierId()));
                }
                evt.getCustomQFilters().add(packageFilter);
                break;
            }
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                long packageId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)this.getModel().getEntryEntity("entrysupplier").get(currIndex)).getDynamicObject("package"));
                if (this.isMultipackage() && packageId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6807\u6bb5\uff0c\u518d\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierChgEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                QFilter supplierFilter = null;
                long supplierId = this.getSupplierId();
                supplierFilter = supplierId > 0L ? new QFilter("id", "=", (Object)supplierId) : SupplierUtil.getAddSupplierFilter((DynamicObject)billObj, (DynamicObject)pBillObj, (long)projectId, (long)0L);
                if (null == supplierFilter) break;
                evt.getCustomQFilters().add(supplierFilter);
                break;
            }
            case "supplieruser": {
                Object currSupObj = this.getModel().getValue("supplier", evt.getRow());
                if (null == currSupObj) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierChgEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)((DynamicObject)currSupObj).getLong("id"));
                QFilter qFilter = new QFilter("bizpartner", "=", (Object)bizPartnerId);
                evt.getCustomQFilters().add(qFilter);
                break;
            }
        }
    }

    private void setPackageVisible() {
        BasedataEdit packageControl = (BasedataEdit)this.getView().getControl("package");
        if (this.isMultipackage()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"package"});
            packageControl.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"package"});
            packageControl.setMustInput(false);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (!this.isMultipackage()) {
            int count = this.getModel().getEntryRowCount("entrysupplier");
            this.getModel().beginInit();
            this.getModel().setValue("package", (Object)this.getPackage(), count - 1);
            this.getModel().endInit();
        }
    }

    public void afterCreateNewData(EventObject e) {
        int count;
        if (!this.isMultipackage() && (count = this.getModel().getEntryRowCount("entrysupplier")) > 0) {
            this.getModel().beginInit();
            this.getModel().setValue("package", (Object)this.getPackage(), count - 1);
            this.getModel().endInit();
        }
    }

    private long getPackage() {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return 0L;
        }
        DynamicObject bidChangeObj = parentView.getModel().getDataEntity();
        QFilter projectFilter = new QFilter("project", "=", (Object)bidChangeObj.getLong("project.id"));
        projectFilter.and("packagename", "in", (Object)"ByItem");
        DynamicObject packageObj = BusinessDataServiceHelper.loadSingle((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{projectFilter});
        return packageObj == null ? 0L : PdsCommonUtils.object2Long((Object)packageObj.getPkValue());
    }

    private boolean isMultipackage() {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return false;
        }
        DynamicObject bidChangeObj = parentView.getModel().getDataEntity();
        return bidChangeObj.getBoolean("project.ismultipackage");
    }

    private int deleteInvalidRows() {
        int index = 0;
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getDataEntity(true).getDynamicObjectCollection("entrysupplier");
        if (rows == null || rows.size() == 0) {
            return index;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("supplier") == null || obj.getLong("supplier.id") == 0L) {
                ite.remove();
                continue;
            }
            ++index;
        }
        this.getView().updateView();
        return index;
    }

    private long getSupplierId() {
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
        return SrmCommonUtil.getPkValue((DynamicObject)dataEntity.getDynamicObject("supplier"));
    }

    private void resetPurAgentValues(int currIndex, String isPurAgentField, String isFeeAgentField, String isPurAptitudeField) {
        if (!this.isPuragentChange) {
            this.isPuragentChange = true;
            SupplierUtil.isPuragentChangedHandle((IFormView)this.getView(), (int)currIndex, (String)isPurAgentField, (String)isFeeAgentField, (String)isPurAptitudeField);
            this.isPuragentChange = false;
        }
    }
}

