/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.bidchange;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcItemSupplierChgEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                this.deleteInvalidRows();
                Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"), (String)"purlist", null, null);
                if (((Boolean)resultMap.get("succed")).booleanValue()) break;
                evt.setCancel(true);
                evt.setCancelMessage(resultMap.get("message").toString());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit supplierControl;
        super.registerListener(e);
        BasedataEdit purlistControl = (BasedataEdit)this.getView().getControl("purlist");
        if (null != purlistControl) {
            purlistControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierControl = (BasedataEdit)this.getView().getControl("supplier"))) {
            supplierControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        long projectId = 0L;
        DynamicObject billObj = this.getView().getModel().getDataEntity();
        DynamicObject pBillObj = !PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView()) ? billObj : this.getView().getParentView().getModel().getDataEntity();
        String propertyName = evt.getProperty().getName();
        projectId = this.getView().getEntityId().equals("src_addsupplier") ? SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project")) : SrmCommonUtil.getPkValue((DynamicObject)pBillObj.getDynamicObject("project"));
        int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (projectId == 0L) {
            return;
        }
        switch (propertyName) {
            case "purlist": {
                QFilter purlistFilter = this.getPurlistFilter(projectId);
                evt.getCustomQFilters().add(purlistFilter);
                break;
            }
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                long purlistId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex)).getDynamicObject("purlist"));
                String addType = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("addsupplier"), (String)"4");
                if ("4".equals(addType) && purlistId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6807\u7684\uff0c\u518d\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcItemSupplierChgEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                QFilter supplierFilter = SupplierUtil.getAddSupplierFilter((DynamicObject)billObj, (DynamicObject)pBillObj, (long)projectId, (long)purlistId);
                if (null == supplierFilter) break;
                evt.getCustomQFilters().add(supplierFilter);
                break;
            }
        }
    }

    private int deleteInvalidRows() {
        int index = 0;
        DynamicObjectCollection rows = ((AbstractFormDataModel)this.getModel()).getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return index;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("purlist") == null || obj.getLong("purlist.id") == 0L) {
                ite.remove();
                continue;
            }
            ++index;
        }
        this.getView().updateView();
        return index;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getSupplierId() > 0L) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"supplier"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "purlist": {
                if (this.getSupplierId() <= 0L) break;
                this.getModel().setValue("supplier", (Object)new Object[]{this.getSupplierId()}, e.getChangeSet()[0].getRowIndex());
            }
        }
    }

    private long getSupplierId() {
        long supplierId = 0L;
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return supplierId;
        }
        if (!Objects.equals(parentView.getEntityId(), "tnd_bidchange")) {
            return supplierId;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        supplierId = SrmCommonUtil.getPkValue((DynamicObject)dataEntity.getDynamicObject("supplier"));
        return supplierId;
    }

    private QFilter getPurlistFilter(long projectId) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "=", (Object)0L);
        qfilters.and("isbizitem", "=", (Object)"0");
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        qfilters.and("purlist.id", "not in", (Object)purListEndIds);
        return qfilters;
    }
}

