/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.botp;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.PdsNoticeTplFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SrcProject2SouNoticeConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        this.afterFieldMappByTemplate(e);
    }

    private void afterFieldMappByTemplate(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entityRows = entitySet.FindByEntityKey("sou_notice");
        if (entityRows.length > 0) {
            String srcType = (String)entityRows[0].getValue("srcbilltype");
            if (StringUtils.isBlank((CharSequence)srcType)) {
                return;
            }
            for (ExtendedDataEntity entityRow : entityRows) {
                DynamicObject targetRow = entityRow.getDataEntity();
                List dynamicObjectList = (List)entityRow.getValue("ConvertSource");
                if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) break;
                DynamicObject obj = (DynamicObject)dynamicObjectList.get(0);
                DynamicObject srcBillObj = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)srcType);
                DynamicObject noticeTpl = targetRow.getDynamicObject("noticetpl");
                if (Objects.isNull(noticeTpl)) break;
                PdsNoticeTplContext noticeContext = new PdsNoticeTplContext(noticeTpl, srcBillObj);
                IPdsNoticeInterface pdsNoticePlugin = PdsNoticeTplFactory.getPdsNoticePluginInstance((PdsNoticeTplContext)noticeContext);
                String contents = pdsNoticePlugin.decorateContent(noticeContext);
                targetRow.set("content", (Object)contents);
                targetRow.set("srcbillno", (Object)srcBillObj.getString("billno"));
                targetRow.set("srcbillid", (Object)obj.getLong("id"));
            }
        }
    }
}

