/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidSummaryUtils;

public class SrcBidopenSummaryEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)"src_compare", (Object)this.getView().getPageId(), (IFormView)parentView);
        SrcBidSummaryUtils.summaryAndDisplay((IDataModel)this.getModel(), (String)"", (String)"entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        switch (fieldName) {
            case "isvalid": 
            case "isenroll": 
            case "isinvite": 
            case "ispayfee": 
            case "isconfirm": 
            case "istender": 
            case "isdiscard": {
                if (PdsCommonUtils.isShowTenderBeforeBidOpen((DynamicObject)this.getView().getParentView().getModel().getDataEntity())) {
                    this.openSupplierModel(rowIndex, fieldName);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5f00\u6807\u4e4b\u540e\u518d\u67e5\u770b\u8be6\u60c5\u3002", (String)"SrcBidopenSummaryEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void openSupplierModel(int rowIndex, String fieldName) {
        ArrayList<String> propertys = new ArrayList<String>(8);
        SrcBidSummaryUtils.setPropertys(propertys);
        Object packageInfo = this.getModel().getValue("package", rowIndex);
        String supplierKey = "0";
        if (packageInfo != null) {
            supplierKey = ((DynamicObject)packageInfo).getString("id");
        }
        String key_property = supplierKey + "_" + fieldName;
        HashMap<String, HashSet<String>> summaryMap = new HashMap<String, HashSet<String>>();
        this.summary("src_enrollsupplier", summaryMap, propertys);
        this.summary("src_bidopensupplier", summaryMap, propertys);
        Set supplierIdSet = (Set)summaryMap.get(key_property);
        if (supplierIdSet != null && !supplierIdSet.isEmpty()) {
            HashMap<String, Set> paramMap = new HashMap<String, Set>();
            paramMap.put("supplier", supplierIdSet);
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"src_supplierselect", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "supplierid"), (ShowType)ShowType.Modal));
        }
    }

    public void summary(String entityName, Map<String, HashSet<String>> summaryMap, List<String> propertys) {
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)true);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"package");
        if (objs == null || objs.size() == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            String packageId = SrcBidSummaryUtils.getPackageId((DynamicObject)obj, (long)billId);
            if (null == packageId) {
                return;
            }
            String supplier = obj.getString("supplier");
            for (String property : propertys) {
                if ("isenroll".equals(property) && "src_bidopensupplier".equals(entityName) || !"isenroll".equals(property) && "src_enrollsupplier".equals(entityName)) continue;
                String key_property = packageId + "_" + property;
                boolean isValid = "src_enrollsupplier".equals(entityName) ? true : SrcBidSummaryUtils.isValid((String)property, (DynamicObject)obj);
                if (!isValid) continue;
                HashSet<String> supplierIdSet = summaryMap.get(key_property);
                if (supplierIdSet != null) {
                    supplierIdSet.add(supplier);
                    summaryMap.put(key_property, supplierIdSet);
                    continue;
                }
                supplierIdSet = new HashSet();
                supplierIdSet.add(supplier);
                summaryMap.put(key_property, supplierIdSet);
            }
        }
    }
}

