/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.patternfilter.PatternFilterUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcCompareConfigEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PdsCommonUtils.isEnableOthRatio((IFormView)this.getView(), (String)"ratio_oth");
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject eventobject) {
        int obj;
        super.beforeBindData(eventobject);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if ("bos_list".equals(parentView.getEntityId())) {
            return;
        }
        SrcAppCache.put((String)"src_compare_config", (Object)this.getView().getPageId(), (IFormView)parentView);
        this.setRatioVisable();
        String sourceType = parentView.getModel().getDataEntity().getString("sourcetype.number");
        Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.NEGOTIATE_SOLE.getValue(), SourceTypeEnums.NEGOTIATE_SOLE2.getValue()});
        if (StringUtils.isBlank((CharSequence)sourceType) || sourceTypeSet.contains(sourceType)) {
            if (this.getModel().getValue("scheme") == null) {
                this.getModel().setValue("scheme", (Object)899232366998897664L);
            }
        } else {
            QFilter qFilter = PatternFilterUtils.getSchemeFilter((IFormView)this.getView());
            if (qFilter == null) {
                this.getPageCache().put("query_qfilter", null);
            } else {
                this.getPageCache().put("query_qfilter", qFilter.toSerializedString());
            }
        }
        this.setMustInput();
        String negotiaterule = this.getModel().getDataEntity(true).getString("negotiaterule");
        if (negotiaterule == null || negotiaterule.length() == 0) {
            this.getModel().setValue("negotiaterule", (Object)"3");
        }
        if ((obj = this.getModel().getDataEntity(true).getInt("topsupplier")) == 0) {
            this.getModel().setValue("topsupplier", (Object)1);
        }
        PatternFilterUtils.setSchemeDefaultValue((IFormView)this.getView());
    }

    private void setRatioVisable() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if ("bos_list".equals(parentView.getEntityId())) {
            return;
        }
        String sourceType = parentView.getModel().getDataEntity().getString("sourcetype.number");
        if (sourceType != null && SourceTypeEnums.SELL_OFF.getValue().equals(sourceType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ratio_tec", "ratio_biz", "ratio_oth", "ratio_syn", "ruleassess", "solereason"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemeEdit = (BasedataEdit)this.getControl("scheme");
        schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit pkgSchemeEdit = (BasedataEdit)this.getControl("pkgscheme");
        pkgSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit packageEdit = (BasedataEdit)this.getControl("package");
        packageEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit negSchemeEdit = (BasedataEdit)this.getView().getControl("negscheme");
        negSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String objectName;
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        switch (objectName = evt.getProperty().getName()) {
            case "scheme": 
            case "pkgscheme": {
                String queryFilter = this.getPageCache().get("query_qfilter");
                if (null == queryFilter) break;
                qFilter = QFilter.fromSerializedString((String)queryFilter);
                showParameter.getListFilterParameter().setFilter(qFilter);
                String orderBy = "matchfield desc,priority,modifytime desc";
                showParameter.getListFilterParameter().setOrderBy(orderBy);
                break;
            }
            case "package": {
                qFilter = new QFilter("project.id", "=", (Object)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "negscheme": {
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("projectf7"), (String)"src_negscheme_filter", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        DynamicObject data = this.getModel().getDataEntity(true);
        switch (opKey) {
            case "calculate": {
                this.getView().invokeOperation("save");
                break;
            }
            case "submit": {
                int obj;
                String negotiaterule = data.getString("negotiaterule");
                if (!StringUtils.equals((CharSequence)"2", (CharSequence)negotiaterule) || (obj = data.getInt("topsupplier")) != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u51e0\u540d\u4f9b\u5e94\u5546\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcCompareConfigEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"negotiaterule", (CharSequence)propertyName)) {
            this.setMustInput();
        }
    }

    private void setMustInput() {
        DynamicObject data = this.getModel().getDataEntity(true);
        DecimalEdit control = (DecimalEdit)this.getView().getControl("topsupplier");
        String negotiaterule = data.getString("negotiaterule");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)negotiaterule)) {
            control.setMustInput(true);
        } else {
            control.setMustInput(false);
        }
        List compKey = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true), (boolean)false);
        if (compKey.contains("src_bidopen_config")) {
            FieldEdit ismanualscore = (FieldEdit)this.getView().getControl("ismanualscore");
            ismanualscore.setFieldKey(null);
            ismanualscore.setVisible("visible", false);
            FieldEdit isbizscore = (FieldEdit)this.getView().getControl("isbizscore");
            isbizscore.setFieldKey(null);
            isbizscore.setVisible("visible", false);
        }
    }
}

