/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.ratio.SrcRatioFacade;
import kd.scm.src.common.calc.total.SrcTotalFacade;
import kd.scm.src.common.enums.SrcDecisionEnum;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcDecisionUtil;

public class SrcDecisionsumSupEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SrcAppCache.put((String)this.getView().getEntityId(), (Object)this.getView().getPageId(), (IFormView)parentView);
        String entityId = parentView.getEntityId();
        if ("src_compare".equals(entityId) || "src_contract".equals(entityId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumtype", "budgetamount", "currency", "contracttype"});
        }
    }

    public void afterBindData(EventObject e) {
        String entityId;
        super.afterBindData(e);
        String sumType = this.getModel().getDataEntity().getString("sumtype");
        if (StringUtils.isBlank((CharSequence)sumType)) {
            this.getModel().setValue("sumtype", (Object)"1");
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("sumtype");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "src_directpur".equals(entityId = parentView.getEntityId())) {
            ArrayList<ComboItem> data = new ArrayList<ComboItem>();
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6807\u7684\u4efd\u989d(\u6570\u91cf)\u8ba1\u7b97\u3002", (String)"SrcDecisionsumSupEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0])), "1"));
            comboEdit.setComboItems(data);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        DynamicObjectCollection entryObjs = this.getModel().getEntryEntity("entryentity");
        if (entryObjs.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryObjs.get(index);
        String sumType = this.getModel().getDataEntity().getString("sumtype");
        switch (key) {
            case "sumtype": {
                this.getModel().beginInit();
                int i = 0;
                for (DynamicObject entryObj : entryObjs) {
                    model.setValue("amount", null, i);
                    model.setValue("taxamount", null, i);
                    model.setValue("orderratio", null, i);
                    model.setValue("orderratio1", null, i);
                    String contractType = entryObj.getString("contracttype");
                    DynamicObjectCollection entityObjs = entryObj.getDynamicObjectCollection("subentryentity");
                    for (int j = 0; j < entityObjs.size(); ++j) {
                        model.setEntryCurrentRowIndex("entryentity", i);
                        if (Objects.equals(contractType, SrcDecisionEnum.TWO_SIDES.getCode())) {
                            model.setValue("signrate", (Object)100, j);
                        } else {
                            model.setValue("signrate", null, j);
                        }
                        model.setValue("signamount", null, j);
                        model.setValue("signtaxamount", null, j);
                    }
                    ++i;
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                IFormView parentView = this.getView().getParentView();
                if (!Objects.nonNull(parentView) || !Objects.equals("src_decision", parentView.getEntityId())) break;
                parentView.getModel().setValue("sumtaxamount", null);
                parentView.getModel().setValue("sumamount", null);
                this.getView().sendFormAction(parentView);
                break;
            }
            case "amount": {
                if (!Objects.equals(sumType, "2")) break;
                if (dynamicObject.getBigDecimal("taxamount").compareTo((BigDecimal)newValue) < 0 && dynamicObject.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) > 0 && ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e2d\u6807\u672a\u7a0e\u91d1\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4e2d\u6807\u542b\u7a0e\u91d1\u989d\u3002", (String)"SrcDecisionsumSupEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    model.setValue("amount", null, index);
                    return;
                }
                this.calAmount("amount", "orderratio");
                SrcDecisionUtil.setSubEntryEntityAmount((IDataModel)model, (int)index, (DynamicObject)dynamicObject, (BigDecimal)((BigDecimal)newValue), (String)"signamount");
                break;
            }
            case "taxamount": {
                if (!Objects.equals(sumType, "2")) break;
                if (dynamicObject.getBigDecimal("amount").compareTo((BigDecimal)newValue) > 0 && dynamicObject.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) > 0 && ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e2d\u6807\u672a\u7a0e\u91d1\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4e2d\u6807\u542b\u7a0e\u91d1\u989d\u3002", (String)"SrcDecisionsumSupEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    model.setValue("taxamount", null, index);
                    return;
                }
                this.calAmount("taxamount", "orderratio1");
                SrcDecisionUtil.setSubEntryEntityAmount((IDataModel)model, (int)index, (DynamicObject)dynamicObject, (BigDecimal)((BigDecimal)newValue), (String)"signtaxamount");
                break;
            }
        }
    }

    private void calAmount(String amountPro, String ratioPro) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryObjs = model.getEntryEntity("entryentity");
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        HashMap<Integer, BigDecimal> taxAmountMap = new HashMap<Integer, BigDecimal>(4);
        for (int j = 0; j < entryObjs.size(); ++j) {
            BigDecimal taxAmount = ((DynamicObject)entryObjs.get(j)).getBigDecimal(amountPro);
            sumTaxAmount = sumTaxAmount.add(taxAmount);
            taxAmountMap.put(j, taxAmount);
        }
        if (sumTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        for (Map.Entry amountEntry : taxAmountMap.entrySet()) {
            BigDecimal ratio = ((BigDecimal)amountEntry.getValue()).divide(sumTaxAmount, 6, 4).multiply(new BigDecimal("100"));
            model.setValue(ratioPro, (Object)ratio, ((Integer)amountEntry.getKey()).intValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String obj;
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (obj = operate.getOperateKey()) {
            case "save": {
                break;
            }
            case "submit": {
                DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                HashSet<String> supplierSet = new HashSet<String>();
                for (DynamicObject entryInfo : entryCols) {
                    DynamicObject supplier;
                    String contracttype = entryInfo.getString("contracttype");
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)contracttype) || (supplier = entryInfo.getDynamicObject("supplier")) == null) continue;
                    long supplierid = SrmCommonUtil.getPkValue((DynamicObject)supplier);
                    DynamicObjectCollection subEnCols = entryInfo.getDynamicObjectCollection("subentryentity");
                    boolean iserr = false;
                    for (DynamicObject subEnInfo : subEnCols) {
                        DynamicObjectCollection attachCols;
                        DynamicObject signsupplier = subEnInfo.getDynamicObject("signsupplier");
                        long signSupplierId = SrmCommonUtil.getPkValue((DynamicObject)signsupplier);
                        if (signSupplierId == 0L || signSupplierId == supplierid || (attachCols = subEnInfo.getDynamicObjectCollection("signsupplierattach")) != null && (attachCols == null || attachCols.size() != 0)) continue;
                        iserr = true;
                    }
                    if (!iserr) continue;
                    supplierSet.add(supplier.getString("name"));
                }
                if (supplierSet == null || supplierSet.isEmpty()) break;
                evt.setCancel(true);
                evt.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e2d\u6807\u4f9b\u5e94\u5546(%1$s),\u5176\u4ed6\u7b7e\u7ea6\u65b9\u672a\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"SrcDecisionsumSupEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]), supplierSet.stream().collect(Collectors.joining("\u3001"))));
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg0) {
        String operateKey;
        super.afterDoOperation(arg0);
        switch (operateKey = arg0.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!arg0.getOperationResult().isSuccess()) {
                    return;
                }
                this.setWinSupplier();
                break;
            }
        }
    }

    private void setWinSupplier() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (!entityId.equals("src_directpur")) {
            return;
        }
        DynamicObject parentDataEntity = parentView.getModel().getDataEntity();
        SrcGlobalCalcContext globalContext = new SrcGlobalCalcContext();
        SrcRatioFacade.getInstance().calculate(entityId, PdsCommonUtils.object2Long((Object)parentDataEntity.getPkValue()), globalContext, false);
        SrcTotalFacade.getInstance().calculate(entityId, PdsCommonUtils.object2Long((Object)parentDataEntity.getPkValue()), globalContext, false);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        String gridKey = grid.getKey();
        if ("entryentity".equals(gridKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (null != row) {
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid"));
                long supplierId = row.getLong("supplier.id");
                String result = row.getString("result");
                QFilter qfilters = new QFilter("project", "=", (Object)projectId);
                qfilters.and("supplier", "=", (Object)supplierId);
                Set resultValueSet = PdsParameterUtils.getOrderRatioResultValueSet();
                if ("1".equals(result) || "3".equals(result)) {
                    qfilters.and("result", "in", (Object)resultValueSet);
                } else {
                    qfilters.and("result", "not in", (Object)resultValueSet);
                }
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_analysetool", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilters, null);
            }
        }
    }
}

