/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.entity.Result;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.enums.ResultEnums;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.common.util.SrcWinruleUtils;
import kd.scm.src.formplugin.comp.SrcPurlistFillRatioBatch;

public class SrcPurlistFillRatio
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        boolean isMultiPackage;
        super.afterBindData(e);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (paraMap == null || null == paraMap.get("isQuickPurchase")) {
            return;
        }
        boolean isQuickPurchase = (Boolean)paraMap.get("isQuickPurchase");
        if (isQuickPurchase) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rank", "sysresult"});
        }
        if (!(isMultiPackage = ((Boolean)paraMap.get("ismultipackage")).booleanValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"package"});
        }
    }

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (paraMap == null) {
            return;
        }
        Object dataObj = paraMap.get("purlistid");
        if (null == dataObj) {
            return;
        }
        this.getModel().setValue("project", (Object)PdsCommonUtils.object2Long(paraMap.get("projectid")));
        this.getModel().setValue("orderratioresult", (Object)PdsCommonUtils.object2String((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio"), (String)"1"));
        Map purlistMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(dataObj), LinkedHashMap.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Map.Entry purlistEntry : purlistMap.entrySet()) {
            String seq = (String)purlistEntry.getKey();
            Map dataMap = (Map)purlistEntry.getValue();
            ts.set("fseq", (Object)seq, i);
            ts.set("entryid", dataMap.get("entryid"), i);
            ts.set("purlist", dataMap.get("purlist"), i);
            ts.set("suppliertype", dataMap.get("suppliertype"), i);
            ts.set("supplier", dataMap.get("supplier"), i);
            ts.set("rank", dataMap.get("rank"), i);
            ts.set("result", dataMap.get("result"), i);
            ts.set("sysresult", dataMap.get("sysresult"), i);
            ts.set("orderratio", dataMap.get("orderratio"), i);
            ts.set("cfmqty", dataMap.get("cfmqty"), i);
            ts.set("qty", dataMap.get("qty"), i);
            ts.set("unit", dataMap.get("unit"), i);
            ts.set("materialnane", dataMap.get("materialnane"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opkey;
        super.beforeDoOperation(evt);
        switch (opkey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "process": {
                this.batchProcess();
                break;
            }
            case "save": {
                Result<String> result = this.verifyOrderRatio();
                if (ResultEnums.SUCCESS.getCode().equals(result.getCode())) {
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)result.getData()))) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0\u4e3a%1$s\u591a\u4e2a\u4f9b\u5e94\u5546\u4e2d\u6807\u4efd\u989d\u4e4b\u548c\u5fc5\u987b\u4e3a100%2$s", (String)"SrcPurlistFillRatio_2", (String)"scm-src-formplugin", (Object[])new Object[0]), ((String)result.getData()).substring(1), "%\u3002"));
                        evt.setCancel(true);
                        return;
                    }
                } else if (ResultEnums.FAIL.getCode().equals(result.getCode())) {
                    this.getView().showErrorNotification((String)result.getData());
                    evt.setCancel(true);
                    return;
                }
                HashMap paraMap = new HashMap();
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                if (rows == null || rows.size() == 0) {
                    return;
                }
                for (DynamicObject row : rows) {
                    HashMap<String, Object> ratioMap = new HashMap<String, Object>(2);
                    String key = row.getString("fseq");
                    ratioMap.put("orderratio", row.getBigDecimal("orderratio"));
                    ratioMap.put("cfmqty", row.getBigDecimal("cfmqty"));
                    ratioMap.put("result", row.getString("result"));
                    paraMap.put(key, ratioMap);
                }
                this.getView().returnDataToParent(paraMap);
                break;
            }
        }
    }

    private void batchProcess() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setBillObj(this.getModel().getDataEntity(true));
        ExtPluginFactory.executeExtplugin((String)SrcPurlistFillRatioBatch.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcPurlistFillRatioBatch.class.getName());
    }

    private Result<String> verifyOrderRatio() {
        StringBuilder materialName = new StringBuilder();
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("sourcetype");
        Set sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.SCHEME_AWARD.getValue(), SourceTypeEnums.SCHEME_AWARD2.getValue()});
        if (sourceTypeSet.contains(sourceType)) {
            return Result.success((Object)materialName.toString());
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        long projectId = ((DynamicObject)rows.get(0)).getLong("purlist.project.id");
        if (!SrcWinruleUtils.isNeedValidateOrderRatio((long)projectId)) {
            return Result.success((Object)materialName.toString());
        }
        Object orderRatioObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        String orderRatio = String.valueOf(orderRatioObj == null ? ",1,2,5," : orderRatioObj);
        List orderRatioIndex = Arrays.stream(orderRatio.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Map<String, List<DynamicObject>> purListMap = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).collect(Collectors.groupingBy(row -> String.valueOf(null == row.getDynamicObject("purlist") ? Long.valueOf(0L) : row.getDynamicObject("purlist").getPkValue())));
        for (Map.Entry<String, List<DynamicObject>> purListEntry : purListMap.entrySet()) {
            List<DynamicObject> materialList = purListEntry.getValue();
            Set supplierSet = materialList.stream().filter(row -> Objects.nonNull(row.getDynamicObject("supplier"))).map(row -> row.getDynamicObject("supplier").getString("id")).collect(Collectors.toSet());
            if (supplierSet.size() != 1) continue;
            for (DynamicObject row2 : materialList) {
                row2.set("orderratio", (Object)new BigDecimal("100"));
            }
        }
        boolean orderRatioIsBreak = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).anyMatch(row -> BigDecimal.ZERO.compareTo(row.getBigDecimal("orderratio")) == 0);
        if (orderRatioIsBreak) {
            String message = orderRatioIndex.stream().map(str -> PdsLettersTypeEnum.fromVal((String)str).getName()).collect(Collectors.joining("/"));
            return Result.failure((Object)String.format(ResManager.loadKDString((String)"%1$s\u4f9b\u5e94\u5546\u4efd\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPurlistFillRatio_1", (String)"scm-src-formplugin", (Object[])new Object[0]), message));
        }
        QFilter qfilter = new QFilter("number", "=", (Object)"SYS108").and("enable", "=", (Object)false);
        if (QueryServiceHelper.exists((String)"pds_validatorconfig", (QFilter[])qfilter.toArray())) {
            return Result.success((Object)materialName.toString());
        }
        Map<String, List<DynamicObject>> purList2Map = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).filter(row -> Objects.nonNull(row.getDynamicObject("purlist"))).collect(Collectors.groupingBy(row -> String.valueOf(row.getDynamicObject("purlist").getDynamicObject("purlist").getPkValue())));
        for (Map.Entry<String, List<DynamicObject>> purList2Entry : purList2Map.entrySet()) {
            BigDecimal sum = purList2Entry.getValue().stream().map(e -> e.getBigDecimal("orderratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sum.compareTo(new BigDecimal(100)) == 0) continue;
            materialName.append(',').append(purList2Entry.getValue().get(0).getDynamicObject("purlist").getString("materialnane"));
        }
        return Result.success((Object)materialName.toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierid = (BasedataEdit)this.getControl("supplierid");
        supplierid.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        Set supplierIds = rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("id", "in", supplierIds);
        evt.getCustomQFilters().add(qfilters);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String proName;
        super.propertyChanged(args);
        switch (proName = args.getProperty().getName()) {
            case "supplierid": {
                this.setOrderRatioBySupplier();
                break;
            }
            case "cfmqty": 
            case "orderratio": {
                SrcPurListUtil.purlistEntryEditHandle((IFormView)this.getView(), (int)args.getChangeSet()[0].getRowIndex(), (String)proName, (PropertyChangedArgs)args);
                break;
            }
        }
    }

    private void setOrderRatioBySupplier() {
        long supplierId = this.getModel().getDataEntity().getLong("supplierid.id");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows.size() == 0) {
            return;
        }
        this.getModel().beginInit();
        for (DynamicObject row : rows) {
            if (row.getLong("supplier.id") == supplierId) {
                row.set("orderratio", (Object)100);
                row.set("cfmqty", row.get("qty"));
                row.set("result", (Object)ResultStatusEnums.WIN.getValue());
                continue;
            }
            row.set("orderratio", (Object)0);
            row.set("cfmqty", (Object)0);
            row.set("result", (Object)ResultStatusEnums.LOSE.getValue());
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }
}

