/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcDecisionUtil;
import kd.scm.src.common.util.SrcQuickPurUtil;

public class SrcPurlistFillRatioEdit
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if ("fillratio".equals(operateKey)) {
            long projectId = SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity());
            if (PdsCommonUtils.isCloseOrTerminated((long)projectId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u518d\u586b\u5199\u4efd\u989d\u3002", (String)"SrcPurlistFillRatioEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Map<String, Map<String, Object>> purlistMap = this.getPurlistMap();
            if (purlistMap != null && purlistMap.size() > 0) {
                HashMap<String, Object> paraMap = new HashMap<String, Object>(1);
                paraMap.put("projectid", projectId);
                paraMap.put("purlistid", SerializationUtils.toJsonString(purlistMap));
                paraMap.put("sourcetype", parentView.getModel().getDataEntity().getString("sourcetype.number"));
                paraMap.put("isQuickPurchase", SrcQuickPurUtil.isQuickPurchase((IFormView)this.getView(), Collections.singletonList("src_decision")));
                paraMap.put("ismultipackage", this.getModel().getValue("ismultipackage"));
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_orderratio", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "fillratio"));
            }
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "fillratio": {
                this.fillOrderRatio((Map)closedCallBackEvent.getReturnData());
                break;
            }
        }
    }

    private Map<String, Map<String, Object>> getPurlistMap() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        ToLongFunction<DynamicObject> function = obj -> obj.getLong("purlist.purlistseq");
        List sList = rows.stream().filter(row -> !row.getBoolean("isdiscarded")).filter(row -> !row.getBoolean("isdecision")).filter(row -> Objects.equals(ProjectStatusEnums.OPENED.getValue(), row.getString("entrystatus"))).sorted(Comparator.comparingLong(function).thenComparingLong(row -> row.getLong("rank"))).collect(Collectors.toList());
        LinkedHashMap<String, Map<String, Object>> purlistMap = new LinkedHashMap<String, Map<String, Object>>(sList.size());
        for (DynamicObject row2 : sList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            long srcEntryId = row2.getLong("srcentryid");
            dataMap.put("entryid", srcEntryId == 0L ? PdsCommonUtils.object2Long((Object)row2.getPkValue()) : srcEntryId);
            dataMap.put("purlist", row2.getLong("purlist.id"));
            dataMap.put("suppliertype", row2.getString("suppliertype"));
            dataMap.put("supplier", row2.getLong("supplier.id"));
            dataMap.put("result", row2.getString("result"));
            dataMap.put("orderratio", row2.getBigDecimal("orderratio"));
            dataMap.put("cfmqty", row2.getBigDecimal("cfmqty"));
            dataMap.put("qty", row2.getBigDecimal("qty"));
            dataMap.put("unit", row2.getLong("unit.id"));
            dataMap.put("rank", row2.getInt("rank"));
            dataMap.put("sysresult", row2.getString("sysresult"));
            dataMap.put("materialnane", row2.getString("materialnane"));
            purlistMap.put(row2.getString("seq"), dataMap);
        }
        return purlistMap;
    }

    private void fillOrderRatio(Map<String, Map<String, Object>> paraMap) {
        if (paraMap == null || paraMap.size() == 0) {
            return;
        }
        DynamicObjectCollection purlistRows = this.getModel().getEntryEntity("entryentity");
        if (purlistRows == null || purlistRows.size() == 0) {
            return;
        }
        int index = 0;
        this.getModel().beginInit();
        for (DynamicObject purlistRow : purlistRows) {
            Map<String, Object> ratioMap = paraMap.get(purlistRow.getString("seq"));
            if (ratioMap != null) {
                this.getModel().setValue("orderratio", ratioMap.get("orderratio"), index);
                this.getModel().setValue("cfmqty", ratioMap.get("cfmqty"), index);
                this.getModel().setValue("result", ratioMap.get("result"), index);
            }
            ++index;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        SrcDecisionUtil.clearSumTaxAmount((IFormView)this.getView());
    }
}

