/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSupplierInvalidEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        boolean isMultiPackage = dataEntity.getBoolean("project.ismultipackage");
        this.getModel().setValue("ismultipackage", (Object)isMultiPackage);
        if (this.getSupplierId() > 0L) {
            this.getModel().setValue("issupplier", (Object)true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)dataEntity.getDynamicObject("project"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)dataEntity.getDynamicObject("supplier"));
        this.loadVieEntryData(projectId, supplierId);
    }

    private void loadVieEntryData(long projectId, long supplierId) {
        DynamicObject[] tenderRows;
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)true);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("isdiscard", "=", (Object)"0");
        if (supplierId > 0L) {
            qfilter.and("supplier", "=", (Object)supplierId);
        }
        if ((tenderRows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilter.toArray())) == null || tenderRows.length == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < tenderRows.length; ++i) {
            DynamicObject row = tenderRows[i];
            for (String pro : properties) {
                try {
                    if (pro.equals("srcentryid")) {
                        ts.set("srcentryid", row.getPkValue(), i);
                        continue;
                    }
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                        continue;
                    }
                    ts.set(pro, row.get(pro), i);
                }
                catch (Exception e) {
                    BizLog.log((String)e.getMessage());
                }
            }
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private long getSupplierId() {
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
        return SrmCommonUtil.getPkValue((DynamicObject)dataEntity.getDynamicObject("supplier"));
    }
}

