/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.comp;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBizItemUtils;

public class SrcTenderQuickAssEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)paraMap)) {
            return;
        }
        long projectId = PdsCommonUtils.object2Long(paraMap.get("projectId"));
        if (projectId == 0L) {
            return;
        }
        DynamicObject[] supRows = this.getTenderBillF7Date(projectId);
        if (Objects.isNull(supRows)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject supRow : supRows) {
            ts.set("package", (Object)supRow.getString("package.id"), index);
            ts.set("suppliertype", (Object)supRow.getString("suppliertype"), index);
            ts.set("supplier", (Object)supRow.getString("supplier.id"), index);
            ts.set("isabandon", (Object)supRow.getBoolean("isabandon"), index);
            ts.set("abandonreason", (Object)supRow.getString("abandonreason"), index);
            ts.set("isconfirm", (Object)supRow.getString("isconfirm"), index);
            ts.set("istender", (Object)supRow.getString("istender"), index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (Objects.equals("bar_save", evt.getItemKey())) {
            Map paraMap = this.getView().getFormShowParameter().getCustomParams();
            if (CollectionUtils.isEmpty((Map)paraMap)) {
                return;
            }
            long projectId = PdsCommonUtils.object2Long(paraMap.get("projectId"));
            if (projectId == 0L) {
                return;
            }
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            boolean isEmpty = rows.stream().filter(row -> row.getBoolean("isabandon")).anyMatch(row -> StringUtils.isEmpty((String)row.getString("abandonreason")));
            if (isEmpty) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u62d2\u6807\u4f9b\u5e94\u5546\u62d2\u6807\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcTenderQuickAssEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject[] supRows = this.getTenderBillF7Date(projectId);
            if (Objects.isNull(supRows)) {
                return;
            }
            for (DynamicObject supRow : supRows) {
                for (DynamicObject row2 : rows) {
                    if (!Objects.equals(supRow.getString("package.id"), row2.getString("package.id")) || !Objects.equals(supRow.getString("supplier.id"), row2.getString("supplier.id"))) continue;
                    supRow.set("isabandon", (Object)row2.getBoolean("isabandon"));
                    supRow.set("abandonreason", (Object)row2.getString("abandonreason"));
                    supRow.set("isconfirm", (Object)row2.getBoolean("isconfirm"));
                    supRow.set("istender", (Object)row2.getBoolean("istender"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])supRows);
            this.clearDecisionAmount(projectId);
            if (SrcBizItemUtils.isNeedCreatePurlistItem((IFormView)this.getView())) {
                SrcBizItemUtils.createPurlistItem((IFormView)this.getView());
            }
            this.getView().returnDataToParent((Object)"save");
        }
    }

    private void clearDecisionAmount(long projectId) {
        DynamicObject decisionObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_decision");
        decisionObj.set("sumamount", null);
        decisionObj.set("sumtaxamount", null);
        decisionObj.set("isedited", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{decisionObj});
    }

    private DynamicObject[] getTenderBillF7Date(long projectId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        DynamicObject[] supRows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"package, suppliertype,supplier, isabandon, abandonreason, isconfirm, istender", (QFilter[])new QFilter[]{qFilter});
        return supRows;
    }
}

