/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.BizLog;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import org.apache.commons.collections.CollectionUtils;

public class SrcBatchDownloadDocHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        context.setSucced(false);
        this.batchDownloadDoc(context);
    }

    public void batchDownloadDoc(ExtPluginContext context) {
        context.setProjectObj(context.getView().getModel().getDataEntity().getDynamicObject("projectf7"));
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        DynamicObjectCollection selectRows = this.getSelectRows(context);
        DynamicObjectCollection validSelectRows = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty((Collection)selectRows)) {
            return;
        }
        if ("2".equals(context.getView().getModel().getDataEntity().getString("origin"))) {
            context.setBillObj(context.getView().getParentView().getModel().getDataEntity());
        }
        Map fileTypeNameMap = ComboEditUtils.getComboKeyValueMapFromEntry((String)context.getView().getEntityId(), (String)"entryentity", (String)"packfiletype");
        long maxFileSize = this.getMaxFileSize();
        ArrayList<BatchDownloadRequest.Dir> dirList = new ArrayList<BatchDownloadRequest.Dir>(selectRows.size());
        long sumFileSize = 0L;
        for (int index = 0; index < selectRows.size(); ++index) {
            DynamicObject row = (DynamicObject)selectRows.get(index);
            DynamicObjectCollection attachRows = row.getDynamicObjectCollection("bidattach");
            if (null == attachRows || attachRows.size() == 0) continue;
            validSelectRows.add((Object)row);
            String fileName = this.getAttachFileName(context, row, fileTypeNameMap, index);
            for (DynamicObject attachRow : attachRows) {
                DynamicObject attachInfo = attachRow.getDynamicObject("fbasedataid");
                if (null == attachInfo) continue;
                ArrayList<BatchDownloadRequest.File> fileList = new ArrayList<BatchDownloadRequest.File>(1);
                this.getAttachFileList(fileList, attachInfo);
                BatchDownloadRequest.Dir tempDir = new BatchDownloadRequest.Dir(fileName);
                tempDir.setFiles(fileList.toArray(new BatchDownloadRequest.File[0]));
                dirList.add(tempDir);
                if ((sumFileSize += PdsCommonUtils.object2Long((Object)attachInfo.get("size"))) < maxFileSize) continue;
                this.batchDownload(context, dirList);
                sumFileSize = 0L;
            }
            if (sumFileSize < maxFileSize) continue;
            this.batchDownload(context, dirList);
            sumFileSize = 0L;
        }
        this.batchDownload(context, dirList);
        context.setSourceObjs((List)validSelectRows);
        context.setSucced(true);
    }

    public void batchDownload(ExtPluginContext context, List<BatchDownloadRequest.Dir> dirList) {
        if (CollectionUtils.isEmpty(dirList)) {
            return;
        }
        String billNo = context.getProjectObj().getString("billno");
        long timeMillis = System.currentTimeMillis();
        String fileName = String.format(ResManager.loadKDString((String)"%1$s_\u5168\u90e8\u9644\u4ef6_%2$s.zip", (String)"SrcBatchDownloadDocHandler_0", (String)"scm-src-formplugin", (Object[])new Object[0]), billNo, timeMillis);
        BatchDownloadRequest bdr = new BatchDownloadRequest(fileName);
        bdr.setDirs(dirList.toArray(new BatchDownloadRequest.Dir[0]));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileService fs = FileServiceFactory.getAttachmentFileService();
        fs.batchDownload(bdr, (OutputStream)out, RequestContext.getOrCreate().getUserAgent());
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TempFileCache e = CacheFactory.getCommonCacheFactory().getTempFileCache();
        int timeout = 7200;
        String tempUrl = e.saveAsUrl(fileName, (InputStream)in, timeout);
        context.getView().download(tempUrl);
        dirList.removeAll(dirList);
    }

    public void getAttachFileList(List<BatchDownloadRequest.File> fileList, DynamicObject attachInfo) {
        if (null == attachInfo) {
            return;
        }
        String url = attachInfo.getString("url");
        String name = attachInfo.getString("name");
        String path = AttachmentUtils.uploadTempFile((String)url, (String)name, null);
        if (url.contains("path=")) {
            path = StringUtils.substringAfter((String)url, (String)"path=");
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            BizLog.log((String)String.format("URLdecode error:%s;path:%s", e.getMessage(), url));
        }
        BizLog.log((String)("###SrcBatchDownloadDocEdit batchdown path:" + url));
        BatchDownloadRequest.File aFile = new BatchDownloadRequest.File(name, path);
        fileList.add(aFile);
    }

    public String getAttachFileName(ExtPluginContext context, DynamicObject row, Map<String, Object> fileTypeNameMap, int index) {
        DynamicObject supplier = row.getDynamicObject("supplier");
        DynamicObject packageObj = row.getDynamicObject("package");
        String packageName = "";
        if (null != packageObj) {
            packageName = packageObj.getString("packagename");
        }
        if ("ByItem".equals(packageName)) {
            packageName = "";
        }
        String supplierName = "";
        if (context.getView().getModel().getDataEntity().getBoolean("projectf7.ishidesupplier")) {
            supplierName = row.getString("suppliercode");
        } else if (supplier != null) {
            supplierName = supplier.getString("name");
        }
        String packfiletype = row.getString("packfiletype");
        if ("src_biddoc_src".equals(context.getView().getEntityId())) {
            supplierName = ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u62db\u6807\u6587\u4ef6", (String)"SrcBatchDownloadDocHandler_1", (String)"scm-src-formplugin", (Object[])new Object[0]);
        }
        supplierName = StringUtils.isEmpty((CharSequence)supplierName) ? "" : supplierName + "-";
        packageName = StringUtils.isEmpty((CharSequence)packageName) ? "" : "-" + packageName;
        LocaleString filetypeName = (LocaleString)fileTypeNameMap.get(packfiletype);
        String fileName = "(" + (index + 1) + ")" + supplierName + filetypeName + packageName;
        return fileName;
    }

    public DynamicObjectCollection getSelectRows(ExtPluginContext context) {
        DynamicObject billObj = context.getView().getModel().getDataEntity(true);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs.length == 0) {
            return rows;
        }
        DynamicObjectCollection selectRows = new DynamicObjectCollection();
        for (int index : selectIndexs) {
            DynamicObject selectRow = (DynamicObject)rows.get(index);
            selectRows.add((Object)selectRow);
        }
        return selectRows;
    }

    public long getMaxFileSize() {
        long maxFileSize = PdsCommonUtils.object2Long((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"maxfilesize"));
        if (maxFileSize == 0L) {
            maxFileSize = 1024L;
        }
        return maxFileSize * 1024L * 1024L;
    }
}

