/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class SrcBitItemCopyHistory
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("entryentity");
        context.setSourceObjs((List)rows);
        this.getHistoryFilter(context);
        this.getHistoryDataMap(context);
        this.setHistoryDataValue(context);
    }

    public void getHistoryFilter(ExtPluginContext context) {
        Set bizitemIds = context.getSourceObjs().stream().filter(e -> e.getLong("supplier.id") > 0L && e.getLong("bizitem.id") > 0L).map(e -> e.getLong("bizitem.id")).collect(Collectors.toSet());
        if (null == bizitemIds || bizitemIds.size() == 0) {
            return;
        }
        Set supplierIds = context.getSourceObjs().stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        if (null == supplierIds || supplierIds.size() == 0) {
            return;
        }
        Date historyDate = SrcDateUtils.getQueryHistoryDate((ExtPluginContext)context);
        QFilter qfilters = new QFilter("supplier", "in", supplierIds);
        qfilters.and("isbizitem", "=", (Object)"1");
        qfilters.and("entrystatus", ">=", (Object)ProjectStatusEnums.QUOTED.getValue());
        qfilters.and("quotedate", ">=", (Object)historyDate);
        qfilters.and("bizitem", "in", bizitemIds);
        qfilters.and("replyvalue", "!=", (Object)" ");
        context.setQfilters(qfilters);
    }

    public void getHistoryDataMap(ExtPluginContext context) {
        if (null == context.getQfilters()) {
            return;
        }
        String selectFields = "suppliertype,supplier,bizitem,reply,replyvalue,purlistentry_supfj";
        String orderby = "bizitem,quotedate desc";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistbizitemf7", (String)selectFields, (QFilter[])context.getQfilters().toArray(), (String)orderby);
        context.setObjMap3(Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("bizitem.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0)))));
    }

    public void setHistoryDataValue(ExtPluginContext context) {
        if (null == context.getObjMap3() || context.getObjMap3().size() == 0) {
            return;
        }
        IDataModel model = context.getView().getModel();
        int count = model.getEntryEntity("entryentity").getRowCount();
        model.beginInit();
        for (int index = 0; index < count; ++index) {
            DynamicObject row = model.getEntryRowEntity("entryentity", index);
            String key = row.getString("supplier.id") + '_' + row.getString("bizitem.id");
            DynamicObject itemObj = (DynamicObject)context.getObjMap3().get(key);
            if (null == itemObj) continue;
            row.set("reply", (Object)itemObj.getString("reply"));
            row.set("replyvalue", (Object)itemObj.getString("replyvalue"));
            row.set("purlistentry_supfj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)itemObj, (String)"purlistentry_supfj"));
        }
        model.endInit();
        context.getView().updateView("entryentity");
    }
}

