/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.compext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public class SrcQuoteBillEntryAttachHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.loadQuoteBillEntryAttach(context);
    }

    private void loadQuoteBillEntryAttach(ExtPluginContext context) {
        String openstatus = context.getView().getModel().getDataEntity().getString("projectf7.openstatus");
        if (StringUtils.isBlank((CharSequence)openstatus)) {
            return;
        }
        if (openstatus.equals(BidOpenStatusEnums.NOOPEN.getValue()) || openstatus.equals(BidOpenStatusEnums.NEGOTIATE.getValue())) {
            return;
        }
        QFilter qfilter = this.getQFilter(context);
        DynamicObject[] purlistRows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"parentid,supplier,package,purlist,purlistentry_supfj", (QFilter[])qfilter.toArray(), (String)"supplier");
        if (purlistRows == null || purlistRows.length == 0) {
            return;
        }
        Set billIds = Arrays.asList(purlistRows).stream().map(e -> e.getLong("parentid")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("id", "in", billIds);
        DynamicObjectCollection tenderRows = QueryServiceHelper.query((String)"tnd_tenderbill", (String)"id,billdate,'1' turns,supplierip", (QFilter[])qfilters.toArray());
        Map<String, DynamicObject> tenderMap = tenderRows.stream().collect(Collectors.groupingBy(e -> e.getString("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        DynamicObjectCollection quoteRows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"id,billdate,turns,supplierip", (QFilter[])qfilters.toArray());
        Map<String, DynamicObject> quoteMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getString("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        DynamicObjectCollection negRows = QueryServiceHelper.query((String)"src_negotiatebill", (String)"id,auditdate billdate,turns,'' supplierip", (QFilter[])qfilters.toArray());
        Map<String, DynamicObject> negMap = negRows.stream().collect(Collectors.groupingBy(e -> e.getString("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        Map<String, List<DynamicObject>> supplierMap = Arrays.asList(purlistRows).stream().collect(Collectors.groupingBy(e -> e.getString("parentid") + '_' + e.getString("supplier.id") + '_' + e.getString("package.id") + '_' + e.getString("purlist.id")));
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            DynamicObjectCollection attachRows = new DynamicObjectCollection();
            HashSet<Long> basedataidSet = new HashSet<Long>();
            for (DynamicObject row : entry.getValue()) {
                DynamicObjectCollection fjRows = row.getDynamicObjectCollection("purlistentry_supfj");
                for (DynamicObject fjRow : fjRows) {
                    if (!basedataidSet.add(fjRow.getLong("fbasedataid.id"))) continue;
                    attachRows.add((Object)fjRow);
                }
            }
            ts.set("suppliertype", (Object)"bd_supplier", i);
            ts.set("supplier", (Object)entry.getValue().get(0).getLong("supplier.id"), i);
            ts.set("package", (Object)entry.getValue().get(0).getLong("package.id"), i);
            ts.set("purlist", (Object)entry.getValue().get(0).getLong("purlist.id"), i);
            ts.set("packfiletype", (Object)"8", i);
            ts.set("bidattach", (Object)attachRows, i);
            String fileName = AttachmentUtils.getAttachFileName((DynamicObjectCollection)attachRows);
            ts.set("packfilename", (Object)fileName, i);
            DynamicObject billObj = tenderMap.get(entry.getValue().get(0).getString("parentid"));
            if (null == billObj && quoteMap.size() > 0) {
                billObj = quoteMap.get(entry.getValue().get(0).getString("parentid"));
            }
            if (null == billObj && negMap.size() > 0) {
                billObj = negMap.get(entry.getValue().get(0).getString("parentid"));
            }
            if (null != billObj) {
                ts.set("billdate", billObj.get("billdate"), i);
                ts.set("turns", billObj.get("turns"), i);
                ts.set("supplierip", billObj.get("supplierip"), i);
            }
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private QFilter getQFilter(ExtPluginContext context) {
        long projectId = context.getView().getModel().getDataEntity().getLong("projectf7.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", ">", (Object)0L);
        qfilter.and("billtype", "!=", (Object)"3");
        qfilter.and("purlistentry_supfj.fbasedataid", ">", (Object)0L);
        return qfilter;
    }
}

