/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsHyperLinkUtils;
import kd.scm.pds.common.util.PdsReportUtils;
import kd.scm.pds.common.util.SrcCalImpl;
import kd.scm.src.common.bizquery.ISrcReferPriceHandler;
import kd.scm.src.common.hyperlink.SrcPurListHyperlinkHandler;
import kd.scm.src.common.pushproject.SrcPushProjectUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcApplyEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private ICal cal = new SrcCalImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (Objects.equals(e.getProperty().getParent().getName(), "entryentity")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            int currRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (rowIndex >= 0 && currRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                grid.selectRows(rowIndex, true);
            }
        }
        if (Objects.isNull(newValue = e.getChangeSet()[0].getNewValue())) {
            return;
        }
        int index = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "unit": {
                PdsCommonUtils.setScaleByUnit((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue), (BigDecimal)((BigDecimal)this.getModel().getValue("reqqty", index)), (String)"reqqty", (int)index);
                break;
            }
            case "biztype": {
                SrcProjectUtil.resetSoureFlow((IFormView)this.getView(), (PropertyChangedArgs)e);
                break;
            }
            case "sourcetype2": {
                this.getModel().setValue("srctype2", null);
                break;
            }
            case "srctype2": {
                if (null != this.getModel().getValue("sourcetype2")) break;
                this.getModel().beginInit();
                this.getModel().setValue("sourcetype2", (Object)((DynamicObject)newValue).getDynamicObject("sourcetype"));
                this.getModel().endInit();
                this.getView().updateView("sourcetype2");
                break;
            }
        }
        this.cal.proChanged(this.getModel(), "entryentity", fieldKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": {
                this.updateReferPrice();
                break;
            }
            case "submit": {
                this.updateReferPrice();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                break;
            }
            case "createpdf": {
                PdsReportUtils.openCreatePdf((IFormView)this.getView(), (boolean)false, null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "resetdemandqty": {
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject row : rows) {
                    row.set("demandqty", (Object)0);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.getView().invokeOperation("refresh");
                break;
            }
            case "resetdemandstatus": {
                DynamicObjectCollection objs = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject obj : objs) {
                    obj.set("demandstatus", (Object)"B");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
                this.getView().invokeOperation("refresh");
                break;
            }
            case "audit": {
                SrcPushProjectUtils.showTipsAfterApplyAudit((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                break;
            }
            case "pushproject": {
                SrcPushProjectUtils.applyManualPushProject((IFormView)this.getView());
                SrcPushProjectUtils.showTipsAfterApplyAudit((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        if (StringUtils.equals((CharSequence)"sourceno", (CharSequence)args.getFieldName())) {
            PdsHyperLinkUtils.editOpenFormByEntryBillNo((IFormView)this.getView(), (HyperLinkClickEvent)args, (String)"sourceno", (String)"src_demand");
        }
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setHyperLinkClickEvent(args);
        ExtPluginFactory.executeExtplugin((String)SrcPurListHyperlinkHandler.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (e.getEntryProp().getName().equals("entryentity") && count > 0) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                this.getModel().setValue("purchasers", (Object)RequestContext.get().getCurrUserId(), row.getRowIndex());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count > 0) {
            this.getModel().setValue("purchasers", (Object)RequestContext.get().getCurrUserId(), count - 1);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String fieldName = e.getEntryProp().getName();
        if ("entryentity".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            if (rows.size() == 0) {
                return;
            }
            this.calcTotalAmount(rows, this.getModel());
        }
    }

    private void calcTotalAmount(DynamicObjectCollection rows, IDataModel model) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject row : rows) {
            sumTaxAmount = sumTaxAmount.add(row.getBigDecimal("taxamount"));
            sumAmount = sumAmount.add(row.getBigDecimal("amount"));
        }
        model.setValue("sumtaxamount", (Object)sumTaxAmount);
        model.setValue("sumamount", (Object)sumAmount);
    }

    public void updateReferPrice() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setRows((DynamicObject[])this.getModel().getEntryEntity("entryentity").toArray((Object[])new DynamicObject[0]));
        context.getParamMap().put("currency", this.getModel().getDataEntity().getLong("currency.id"));
        context.getParamMap().put("fieldnamecurrency", "currency.id");
        context.getParamMap().put("fieldnamematerial", "material.id");
        context.getParamMap().put("fieldnameunit", "unit.id");
        ExtPluginFactory.executeExtplugin((String)(ISrcReferPriceHandler.class.getSimpleName() + "_apply"), (ExtPluginContext)context, (boolean)false);
        this.getView().updateView("entryentity");
    }
}

