/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsHyperLinkUtils;

public class SrcApplyToProjectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    public void beforeBindData(EventObject e) {
        this.setSourceFlowMustInput();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getModel().beginInit();
            this.setSceneDefaultValue();
            this.getModel().endInit();
            this.getView().updateView("sourcetype2");
        }
    }

    public void setSceneDefaultValue() {
        if ("0".equals(this.getModel().getDataEntity().getString("isproject"))) {
            return;
        }
        DynamicObject sourceFlowObj = this.getModel().getDataEntity().getDynamicObject("srctype2");
        DynamicObject sourceTypeObj = this.getModel().getDataEntity().getDynamicObject("sourcetype2");
        if (null != sourceFlowObj && null == sourceTypeObj) {
            this.getModel().setValue("sourcetype2", (Object)sourceFlowObj.getDynamicObject("sourcetype"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit srcType2 = (BasedataEdit)this.getControl("srctype2");
        if (Objects.nonNull(srcType2)) {
            srcType2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "srctype2": {
                this.setSrctypeSelect(evt);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "isproject": {
                this.setSourceFlowMustInput();
                break;
            }
        }
    }

    private void setSrctypeSelect(BeforeF7SelectEvent evt) {
        DynamicObject sourcetype = this.getModel().getDataEntity().getDynamicObject("sourcetype2");
        if (sourcetype != null) {
            QFilter qfilter = new QFilter("sourcetype", "=", sourcetype.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qfilter);
        }
    }

    private void setSourceFlowMustInput() {
        if ("0".equals(this.getModel().getDataEntity().getString("isproject"))) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"srctype2", (boolean)false);
        } else {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"srctype2", (boolean)true);
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent arg0) {
        BasedataEdit basedataEdit = (BasedataEdit)arg0.getSource();
        switch (basedataEdit.getKey()) {
            case "project": {
                arg0.setCancel(true);
                PdsHyperLinkUtils.openTargetBill((IFormView)this.getView(), (String)"src_project", (long)PdsCommonUtils.object2Long((Object)arg0.getPkId()));
                break;
            }
        }
    }
}

