/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcAptitudeUtils;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcAptitudeAuditEdit2
extends AbstractBillPlugIn {
    private static String NOT_SHOW_MESSAGE = "notShowMessage";

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.setDefaultValue();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (key) {
            case "notify": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u901a\u77e5\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5229\u76ca\u5173\u7cfb\u6f84\u6e05\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SrcAptitudeAuditEdit2_0", (String)"scm-src-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("notify"));
                evt.setCancel(true);
                break;
            }
            case "todotask": {
                QFilter qFilter = new QFilter("project", "=", (Object)billId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_memberclarify", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "suppliertype": {
                SrcAptitudeUtils.deleteScoreTask((IFormView)this.getView());
                break;
            }
        }
    }

    private void setDefaultValue() {
        String billStatus = PdsCommonUtils.object2String((Object)this.getModel().getValue("billstatus"), (String)BillStatusEnum.SAVE.getVal());
        if (!BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            return;
        }
        boolean isChanged = false;
        if (this.getModel().getValue("template") == null) {
            TemplateUtil.setDefaultTemplate((IDataModel)this.getModel(), (String)PdsBizNodeEnums.APTITUDEAUDIT2.getValue());
            isChanged = true;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            isChanged = true;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("bizstatus"))) {
            this.getModel().setValue("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
            isChanged = true;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("srctype"));
        boolean isManualScoreTask = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"ismanualscoretask", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity())));
        if (PdsCommonUtils.isOpenBySupplier((DynamicObject)this.getModel().getDataEntity()) || isManualScoreTask) {
            this.getModel().setValue("suppliertype", (Object)"3");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"suppliertype"});
            isChanged = true;
        }
        if (isChanged) {
            this.getModel().setDataChanged(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opKey;
        super.beforeDoOperation(evt);
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "bidresult": {
                SrcBidAssessUtils.openBidAssessResult((IFormView)this.getView());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("basetype", "7");
        switch (opKey) {
            case "aptitudehelper": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("project", projectId);
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_scoreassist", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "aptitudehelper"));
                break;
            }
            case "aptitudeanalyse": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("projectids", PdsCommonUtils.buildSet((Long[])new Long[]{projectId}));
                    OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scoreanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
                    break;
                }
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scoreanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
                break;
            }
            case "allopen": 
            case "tecopen": 
            case "bizopen": 
            case "recalculate": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "aptitudehelper": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "notify": {
                if (evt.getResult() != MessageBoxResult.Yes) {
                    return;
                }
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                if (projectId == 0L) {
                    return;
                }
                Map notifyMap = SrcClarifyUtils.notifyAllMember((IFormView)this.getView(), (long)projectId, (String)"src_project_man");
                if (((Boolean)notifyMap.get("succed")).booleanValue()) {
                    this.getView().showSuccessNotification(notifyMap.get("message").toString());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showTipNotification(notifyMap.get("message").toString());
                break;
            }
        }
    }
}

