/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.CommonUtil;

public class SrcBaseQtyCalcEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String fieldKey = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String entityId = this.getEntityId(this.getView());
        Map<String, String> calcKeys = this.getFieldKeys(entityId);
        if (CollectionUtils.isEmpty(calcKeys)) {
            return;
        }
        if (this.isCalc(entityId, fieldKey, calcKeys)) {
            DynamicObject col = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            this.getModel().setValue("baseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)col.getDynamicObject(calcKeys.get("material")), (DynamicObject)col.getDynamicObject(calcKeys.get("unit")), (BigDecimal)col.getBigDecimal(calcKeys.get("qty")), (DynamicObject)col.getDynamicObject(calcKeys.get("baseunit"))), rowIndex);
        }
        if (Objects.equals(fieldKey, calcKeys.get("material")) && Objects.nonNull(newValue = e.getChangeSet()[0].getNewValue())) {
            DynamicObject material = (DynamicObject)newValue;
            this.materialChanged(this.getModel(), calcKeys.get("unit"), material, rowIndex);
            this.getModel().setValue(calcKeys.get("baseunit"), (Object)material.getLong("baseunit_id"), rowIndex);
        }
    }

    private void materialChanged(IDataModel model, String propertyName, DynamicObject material, int rowIndex) {
        DynamicObject materialPurchaseInfo;
        String selectFields = "id,masterid,purchaseunit";
        String entity = model.getDataEntityType().getName();
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
        QFilter qFilter = new QFilter("masterid", "=", (Object)material.getLong("masterid"));
        if (properties.containsKey((Object)"org")) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialpurchaseinfo", (Long)model.getDataEntity().getLong("org_id"));
            qFilter.and(baseDataFilter);
        }
        if (null != (materialPurchaseInfo = QueryServiceHelper.queryOne((String)"bd_materialpurchaseinfo", (String)selectFields, (QFilter[])new QFilter[]{qFilter}))) {
            long purUnitId = materialPurchaseInfo.getLong("purchaseunit");
            if (purUnitId == 0L) {
                model.setValue(propertyName, (Object)material.getLong("baseunit_id"), rowIndex);
            } else {
                model.setValue(propertyName, (Object)purUnitId, rowIndex);
            }
        } else {
            model.setValue(propertyName, (Object)material.getLong("baseunit_id"), rowIndex);
        }
    }

    private String getEntityId(IFormView view) {
        String entityId = view.getEntityId();
        if (Objects.equals("src_demand", entityId) || Objects.equals("src_demand_comp", entityId) || Objects.equals("src_apply", entityId) || Objects.equals("src_materialchg", entityId) || Objects.equals("src_decisionchg", entityId)) {
            return entityId;
        }
        IFormView parentView = view.getParentView();
        if (Objects.isNull(parentView)) {
            return entityId;
        }
        entityId = parentView.getEntityId();
        return entityId;
    }

    private Map<String, String> getFieldKeys(String entityId) {
        HashMap<String, String> calcKeys = new HashMap<String, String>(4);
        switch (entityId) {
            case "src_project": 
            case "src_purlist": {
                calcKeys.put("material", "material");
                calcKeys.put("unit", "unit");
                calcKeys.put("qty", "qty");
                calcKeys.put("baseunit", "baseunit");
                break;
            }
            case "src_demand": 
            case "src_demand_comp": {
                calcKeys.put("material", "material1");
                calcKeys.put("unit", "unit2");
                calcKeys.put("qty", "qty");
                calcKeys.put("baseunit", "baseunit");
                break;
            }
            case "src_apply": {
                calcKeys.put("material", "material");
                calcKeys.put("unit", "unit");
                calcKeys.put("qty", "reqqty");
                calcKeys.put("baseunit", "baseunit");
                break;
            }
            case "src_materialchg": {
                calcKeys.put("material", "material");
                calcKeys.put("unit", "unit");
                calcKeys.put("qty", "qty");
                calcKeys.put("baseunit", "baseunit");
                break;
            }
            case "src_decisionchg": {
                calcKeys.put("material", "material_new");
                calcKeys.put("unit", "unit_new");
                calcKeys.put("qty", "qty_new");
                calcKeys.put("baseunit", "baseunit");
                break;
            }
        }
        return calcKeys;
    }

    private boolean isCalc(String entityId, String fieldKey, Map<String, String> calcKays) {
        boolean isCalc = false;
        block9 : switch (entityId) {
            case "src_project": 
            case "src_purlist": 
            case "src_demand": 
            case "src_demand_comp": 
            case "src_apply": 
            case "src_materialchg": 
            case "src_decisionchg": {
                for (Map.Entry<String, String> calcKayEntry : calcKays.entrySet()) {
                    if (!Objects.equals(calcKayEntry.getValue(), fieldKey)) continue;
                    isCalc = true;
                    break block9;
                }
                break;
            }
        }
        return isCalc;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Map<String, String> calcKeys = this.getFieldKeys(this.getEntityId(this.getView()));
        if (CollectionUtils.isEmpty(calcKeys)) {
            return;
        }
        BasedataEdit unit = (BasedataEdit)this.getControl(calcKeys.get("unit"));
        if (unit != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        Map<String, String> calcKeys = this.getFieldKeys(this.getEntityId(this.getView()));
        if (CollectionUtils.isEmpty(calcKeys)) {
            return;
        }
        if (Objects.equals(name, calcKeys.get("unit"))) {
            int row = beforeF7SelectEvent.getRow();
            DynamicObject material = (DynamicObject)this.getModel().getValue(calcKeys.get("material"), row);
            if (material == null) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(material.getLong("baseunit_id"));
            QFilter qFilter = new QFilter("srcmuid", "in", ids);
            qFilter.or("desmuid", "in", ids);
            QFilter[] filters1 = new QFilter[]{qFilter};
            Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunitconv", (String)"srcmuid,desmuid,numerator, denominator, converttype", (QFilter[])filters1);
            result.forEach((key, info) -> {
                ids.add(info.getLong("srcmuid_id"));
                ids.add(info.getLong("desmuid_id"));
            });
            QFilter[] filters = new QFilter[]{new QFilter("materialid", "=", material.getPkValue())};
            String selectFields = "id,measureunitid.id";
            Map multimeasureunits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)selectFields, (QFilter[])filters);
            multimeasureunits.forEach((key, info) -> ids.add(info.getLong("measureunitid.id")));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
            showParameter.setMultiSelect(false);
        }
    }
}

