/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcPurListUtil;
import kd.scm.src.formplugin.compext.SrcBidassessRatioValidator;

public class SrcBidAssessQuick
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit purListEdit;
        BasedataEdit supplierEdit;
        super.registerListener(e);
        BasedataEdit packageEdit = (BasedataEdit)this.getControl("package");
        if (!Objects.isNull(packageEdit)) {
            packageEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!Objects.isNull(supplierEdit = (BasedataEdit)this.getControl("supplier"))) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!Objects.isNull(purListEdit = (BasedataEdit)this.getControl("purlist"))) {
            purListEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String keyName = beforeF7SelectEvent.getProperty().getName();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Object id = parentView.getModel().getDataEntity().getPkValue();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (keyName) {
            case "package": {
                DynamicObject obj = this.getPackage();
                if (null == obj) {
                    List<String> packageList = this.getPurListF7Data(id, "packagename");
                    QFilter qFilter = new QFilter("packagename", "in", packageList);
                    qFilter.and(new QFilter("project", "=", id));
                    listShowParameter.getListFilterParameter().setFilter(qFilter);
                    break;
                }
                QFilter qFilter = new QFilter("id", "=", obj.getPkValue());
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "supplier": {
                listShowParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                int row = beforeF7SelectEvent.getRow();
                DynamicObject packageObj = (DynamicObject)this.getModel().getValue("package", row);
                List supplierIds = new ArrayList(16);
                if (null != packageObj) {
                    supplierIds = SrcPurListUtil.getInviteSupplier((Object)id, (Object)packageObj.getPkValue());
                }
                QFilter qFilter = new QFilter("id", "in", supplierIds);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "purlist": {
                DynamicObject curRow = this.getModel().getEntryRowEntity("entryentity", beforeF7SelectEvent.getRow());
                QFilter purFilter = new QFilter("project", "=", id);
                List<String> purList = this.getPurListF7Data(id, "purlist.id");
                List purListIds = purList.stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
                purFilter.and(new QFilter("entryid", "in", purListIds));
                DynamicObject packageObject = curRow.getDynamicObject("package");
                Object packageId = null;
                if (Objects.nonNull(packageObject)) {
                    packageId = packageObject.getPkValue();
                }
                purFilter.and(new QFilter("package", "=", packageId));
                listShowParameter.getListFilterParameter().setFilter(purFilter);
                break;
            }
        }
    }

    private DynamicObject getPackage() {
        String parentId = this.getModel().getDataEntity().getString("parentid");
        QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(parentId));
        projectFilter.and("packagename", "in", (Object)"ByItem");
        return BusinessDataServiceHelper.loadSingle((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{projectFilter});
    }

    private List<String> getPurListF7Data(Object projectId, String propertiesName) {
        DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_purlist");
        List compKeys = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)purListObj);
        ArrayList<String> packageList = new ArrayList<String>(16);
        for (String compKey : compKeys) {
            DynamicObject purListCompObj;
            if (Objects.equals("src_purlist_item", compKey) || null == (purListCompObj = TemplateUtil.getComponentData((Object)purListObj.getPkValue(), (String)"src_purlist", (String)compKey))) continue;
            DynamicObjectCollection rows = purListCompObj.getDynamicObjectCollection("entryentity");
            List list = rows.stream().map(row -> row.getString(propertiesName)).distinct().collect(Collectors.toList());
            packageList.addAll(list);
        }
        return packageList;
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key;
        super.propertyChanged(evt);
        switch (key = evt.getProperty().getName()) {
            case "bizscore": 
            case "tecscore": 
            case "othscore": {
                this.verifyLargeRatio(this.getView(), evt);
                break;
            }
        }
    }

    private void verifyLargeRatio(IFormView view, PropertyChangedArgs evt) {
        List validators = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidassessRatioValidator.class.getSimpleName(), null);
        for (SrcBidassessRatioValidator validator : validators) {
            validator.verifyLargeRatio(view, evt);
        }
    }
}

