/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.entity.Result;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.enums.ResultEnums;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcBidNumberChangeEntryEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        DynamicObjectCollection purCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        SrcAppCache.put((String)"src_ratiochg", (Object)this.getView().getPageId(), (IFormView)parentView);
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        String project = dataEntity.getString("project.billno");
        if (purCollection.size() == 0) {
            QFilter qfilter = new QFilter("project.billno", "=", (Object)project).and("entrystatus", "=", (Object)"C");
            qfilter.and("isbizitem", "=", (Object)"0");
            DynamicObjectCollection purlistCols = QueryServiceHelper.query((String)"src_purlistf7", (String)"id,purlist,entryid,turns,package,package.id,packagename,suppliertype,supplier,material,materialnane,category,result,orderratio,entrystatus", (QFilter[])new QFilter[]{qfilter});
            this.createPurlistEntryData("entryentity", purlistCols);
        }
        if (!dataEntity.getBoolean("project.ismultipackage")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"packagename"});
        }
    }

    private void createPurlistEntryData(String entryKey, DynamicObjectCollection objs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryKey);
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        boolean isSetColor = false;
        long prePurlistID = 0L;
        if (objs.size() > 0) {
            for (DynamicObject obj : objs) {
                ts.set("turns", obj.get("turns"), i);
                ts.set("packagename", obj.get("packagename"), i);
                ts.set("supplier", obj.get("supplier"), i);
                ts.set("material", obj.get("material"), i);
                ts.set("materialnane", obj.get("materialnane"), i);
                ts.set("category", obj.get("category"), i);
                ts.set("result", obj.get("result"), i);
                ts.set("orderratio", obj.get("orderratio"), i);
                ts.set("entrystatus", obj.get("entrystatus"), i);
                ts.set("srcentryid", obj.get("entryid"), i);
                ts.set("purlist", obj.get("purlist"), i);
                ts.set("package", obj.get("package.id"), i);
                long purlistId = 0L;
                purlistId = obj.getLong("purlist");
                if (prePurlistID == 0L) {
                    prePurlistID = purlistId;
                }
                if (purlistId != prePurlistID) {
                    isSetColor = !isSetColor;
                    prePurlistID = purlistId;
                }
                ++i;
            }
        }
        model.batchCreateNewEntryRow(entryKey, ts);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opkey;
        super.beforeDoOperation(evt);
        switch (opkey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": {
                Result<String> result = this.verifyOrderRatio();
                if (ResultEnums.SUCCESS.getCode().equals(result.getCode())) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)result.getData()))) break;
                    evt.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0\u4e3a%1$s\u591a\u4e2a\u4f9b\u5e94\u5546\u4e2d\u6807\u4efd\u989d\u4e4b\u548c\u5fc5\u987b\u4e3a100%2$s", (String)"SrcBidNumberChangeEntryEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]), ((String)result.getData()).substring(1), "%"));
                    evt.setCancel(true);
                    return;
                }
                if (!ResultEnums.FAIL.getCode().equals(result.getCode())) break;
                evt.setCancelMessage((String)result.getData());
                evt.setCancel(true);
                return;
            }
        }
    }

    private Result<String> verifyOrderRatio() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return Result.success();
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (!SrcWinruleUtils.isNeedValidateOrderRatio((long)((Long)projectObj.getPkValue()))) {
            return Result.success();
        }
        StringBuilder materialName = new StringBuilder();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        Object orderRatioObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        String orderRatio = String.valueOf(orderRatioObj == null ? ",1,2,5," : orderRatioObj);
        List orderRatioIndex = Arrays.stream(orderRatio.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Boolean orderRatioIsBreak = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).anyMatch(row -> BigDecimal.ZERO.compareTo(row.getBigDecimal("orderrationew")) == 0);
        if (orderRatioIsBreak.booleanValue()) {
            String message = orderRatioIndex.stream().map(str -> PdsLettersTypeEnum.fromVal((String)str).getName()).collect(Collectors.joining("/"));
            return Result.failure((Object)String.format(ResManager.loadKDString((String)"%1$s\u4f9b\u5e94\u5546\u4efd\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcBidNumberChangeEntryEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]), message));
        }
        QFilter qfilter = new QFilter("number", "=", (Object)"SYS108").and("enable", "=", (Object)false);
        if (QueryServiceHelper.exists((String)"pds_validatorconfig", (QFilter[])qfilter.toArray())) {
            return Result.success((Object)materialName.toString());
        }
        Map<String, List<DynamicObject>> purList2Map = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).filter(row -> Objects.nonNull(row.getDynamicObject("purlist"))).collect(Collectors.groupingBy(row -> String.valueOf(row.getDynamicObject("purlist").getPkValue())));
        for (Map.Entry<String, List<DynamicObject>> purList2Entry : purList2Map.entrySet()) {
            BigDecimal sum = purList2Entry.getValue().stream().map(e -> e.getBigDecimal("orderrationew")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sum.compareTo(new BigDecimal(100)) == 0) continue;
            materialName.append(',').append(purList2Entry.getValue().get(0).getDynamicObject("purlist").getString("materialnane"));
        }
        return Result.success((Object)materialName.toString());
    }
}

