/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.pds.common.util.PdsReportUtils;
import kd.scm.pds.common.util.SrcTypeUtil;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.util.PermissionUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcBidbillCompTplEdit
extends AbstractBillPlugIn
implements WizardStepsListener {
    public static final String WIZARDAP_STEP = "wizardap_step";
    public static final String AUTONEXTNODE_ISSHOWMESSAGE = "autoNextNode_isShowMessage";
    public static final String END_PAGE = "end_page";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String entityKey;
        BillShowParameter formShowParam = (BillShowParameter)e.getFormShowParameter();
        Object pkId = formShowParam.getPkId();
        String nodeName = this.getTitle(pkId, entityKey = formShowParam.getFormConfig().getEntityTypeId());
        if (StringUtils.isNotEmpty((String)nodeName)) {
            formShowParam.setCaption(nodeName);
        }
    }

    public String getTitle(Object pkId, String entityKey) {
        String nodeName = "";
        if (Objects.nonNull(pkId)) {
            DynamicObject dataObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityKey);
            DynamicObject currNodeCol = SrcBidCompTplUtil.getCurrNode((DynamicObject)dataObj, (boolean)false);
            if (null == currNodeCol) {
                return nodeName;
            }
            DynamicObject bizNode = null;
            if (currNodeCol.getDataEntityType() instanceof SubEntryType) {
                bizNode = currNodeCol.getDynamicObject("subbiznode");
                nodeName = currNodeCol.getString("subnodename");
            } else {
                bizNode = currNodeCol.getDynamicObject("biznode");
                nodeName = currNodeCol.getString("nodename");
            }
            if (null == bizNode) {
                return nodeName;
            }
            if (StringUtils.isEmpty((String)nodeName)) {
                nodeName = bizNode.getString("name");
            }
        } else {
            DynamicObject bizNode;
            QFilter bizNodefilter = new QFilter("enable", "=", (Object)"1");
            if (null != entityKey) {
                bizNodefilter.and("bizobject", "=", (Object)entityKey);
            }
            if (null != (bizNode = BusinessDataServiceHelper.loadSingle((String)"pds_biznode", (String)"id,name", (QFilter[])bizNodefilter.toArray()))) {
                nodeName = bizNode.getString("name");
            }
        }
        return nodeName;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Wizard wizard = (Wizard)this.getControl("status_wizardap");
        wizard.addClickListener((ClickListener)this);
        wizard.addItemClickListener((ItemClickListener)this);
        wizard.addWizardStepsListener((WizardStepsListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "refresh": {
                break;
            }
            case "nextnode": {
                this.nextNode();
                break;
            }
            case "previousnode": {
                this.previousNode();
                break;
            }
            case "processingnode": {
                this.processingNode();
                break;
            }
            case "createpdf": {
                PdsReportUtils.openCreatePdf((IFormView)this.getView(), (boolean)false, null);
                break;
            }
        }
    }

    protected void nextNode() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject nextNode = PdsFlowConfigUtils.getChildrenNode((DynamicObject)obj, (boolean)false);
        if (null == nextNode) {
            boolean isShowMessage = this.isShowMessage();
            if (isShowMessage) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u4e00\u4e2a\u8282\u70b9\u3002", (String)"SrcBidbillCompTplEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        this.showNode(nextNode, true);
    }

    protected void previousNode() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject parentNode = SrcBidCompTplUtil.getParentNode((DynamicObject)obj, (boolean)false);
        if (null == parentNode) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0a\u4e00\u4e2a\u8282\u70b9\u3002", (String)"SrcBidbillCompTplEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showNode(parentNode, true);
    }

    protected void processingNode() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject processingNode = SrcBidCompTplUtil.getProcessingNode((DynamicObject)obj);
        if (null == processingNode) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u8282\u70b9\u3002", (String)"SrcBidbillCompTplEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showNode(processingNode, true);
    }

    private void showNode(DynamicObject node, boolean isCloseCurrPage) {
        if (Objects.isNull(node)) {
            return;
        }
        String nextNode_objectKey = null;
        String nodeName = "";
        if (node.getDataEntityType() instanceof SubEntryType) {
            nextNode_objectKey = node.getString("subbizobject");
            nodeName = node.getDynamicObject("subbiznode").getString("name");
        } else {
            nextNode_objectKey = node.getString("bizobject");
            nodeName = node.getDynamicObject("biznode").getString("name");
        }
        DynamicObject obj = this.getModel().getDataEntity();
        obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)obj.getDynamicObjectType());
        boolean isShowMessage = this.isShowMessage();
        String hasPermission = PermissionUtils.hasPermission((String)nextNode_objectKey, (DynamicObject)obj);
        if (StringUtils.isEmpty((String)hasPermission)) {
            if (isShowMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"SrcBidbillCompTplEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if (this.verifyNode(nextNode_objectKey, obj, isShowMessage)) {
            DynamicObject bizNodeObj;
            String currAppId;
            String appId;
            IFormView openedView;
            IFormView view = this.getView();
            OperationStatus operationStatus = Objects.equals(hasPermission, "4715a0df000000ac") ? OperationStatus.EDIT : OperationStatus.VIEW;
            BillShowParameter param = BillFormUtil.assembleShowBillFormParam((String)nextNode_objectKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)operationStatus, (long)PdsCommonUtils.object2Long((Object)obj.getPkValue()), null, null);
            param.setCaption(nodeName);
            String pageId = this.getCachedPageId(nextNode_objectKey, obj.getPkValue());
            if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = this.getView().getViewNoPlugin(pageId)) && (appId = openedView.getFormShowParameter().getAppId()).equals(currAppId = view.getFormShowParameter().getAppId())) {
                param.setPageId(pageId);
            }
            view.showForm((FormShowParameter)param);
            if (isCloseCurrPage && null != (bizNodeObj = this.getBizNodeObj()) && bizNodeObj.getBoolean("isautoclose")) {
                view.close();
            }
        }
    }

    private void cachePageId(String entityKey, Object pkVal, String pageId) {
        IFormView mainView = this.getView().getMainView();
        if (null == mainView) {
            return;
        }
        IAppCache appCache = AppCache.get((String)"src");
        appCache.put(SrcAppCache.getCacheOpenedPageIdKey((IFormView)this.getView(), (String)entityKey, (Object)pkVal), (Object)pageId);
    }

    private String getCachedPageId(String entityKey, Object pkVal) {
        IFormView mainView = this.getView().getMainView();
        if (null == mainView) {
            return null;
        }
        IAppCache appCache = AppCache.get((String)"src");
        return (String)appCache.get(SrcAppCache.getCacheOpenedPageIdKey((IFormView)this.getView(), (String)entityKey, (Object)pkVal), String.class);
    }

    private boolean verifyNode(String nodeName, DynamicObject obj, boolean isShowMessage) {
        DynamicObject crrNode = SrcBidCompTplUtil.getCurrNode((DynamicObject)obj, (String)nodeName, (boolean)false);
        if (null == crrNode) {
            if (isShowMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u6b64\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u4e0b\u4e00\u6b65\u3002", (String)"SrcBidbillCompTplEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        String bizStatus = null;
        String bizStatusKey = null;
        bizStatusKey = crrNode.getDataEntityType() instanceof SubEntryType ? "subflowbizstatus" : "flowbizstatus";
        bizStatus = crrNode.getString(bizStatusKey);
        if (bizStatus == null || SrcBizStatusEnum.NOTSTART.getVal().equals(bizStatus) || bizStatus.trim().length() == 0) {
            if (isShowMessage) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u672a\u5f00\u59cb\uff0c\u4e0d\u80fd\u6267\u884c\u4e0b\u4e00\u6b65\u3002", (String)"SrcBidbillCompTplEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private boolean isShowMessage() {
        IPageCache cache = this.getPageCache();
        String isShowMessage = cache.get(AUTONEXTNODE_ISSHOWMESSAGE);
        return null == isShowMessage || !Boolean.FALSE.toString().equals(isShowMessage);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        switch (operateKey) {
            case "audit": {
                if (null != result && result.isSuccess() && this.isAutoShowNextNode()) {
                    IPageCache cache = this.getPageCache();
                    cache.put(AUTONEXTNODE_ISSHOWMESSAGE, Boolean.FALSE.toString());
                    this.nextNode();
                    cache.remove(AUTONEXTNODE_ISSHOWMESSAGE);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unaudit": {
                if (null != result && result.isSuccess()) {
                    this.closeNextNode();
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void closeNextNode() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject nextNode = PdsFlowConfigUtils.getChildrenNode((DynamicObject)obj, (boolean)false);
        if (null != nextNode) {
            IFormView openedView;
            String nextNode_objectKey = null;
            nextNode_objectKey = nextNode.getDataEntityType() instanceof SubEntryType ? nextNode.getString("subbizobject") : nextNode.getString("bizobject");
            String pageId = this.getCachedPageId(nextNode_objectKey, obj.getPkValue());
            if (StringUtils.isNotEmpty((String)pageId) && null != (openedView = this.getView().getView(pageId))) {
                openedView.close();
                this.getView().sendFormAction(openedView);
            }
        }
    }

    protected boolean isAutoShowNextNode() {
        DynamicObject bizNodeObj;
        IDataModel model = this.getModel();
        String entityName = model.getDataEntityType().getName();
        boolean isShowNextNode = true;
        switch (entityName) {
            case "src_purlist": {
                isShowNextNode = false;
                break;
            }
            case "src_decision": {
                break;
            }
        }
        if (isShowNextNode) {
            boolean bl = isShowNextNode = !PdsParameterUtils.isInviteByParam((IDataModel)model);
        }
        if (isShowNextNode && null != (bizNodeObj = this.getBizNodeObj())) {
            isShowNextNode = bizNodeObj.getBoolean("isautonextnode");
        }
        return isShowNextNode;
    }

    private DynamicObject getBizNodeObj() {
        String entityName = this.getView().getEntityId();
        QFilter nodeFilter = new QFilter("bizobject", "=", (Object)entityName);
        DynamicObject bizNodeObj = BusinessDataServiceHelper.loadSingle((String)"pds_biznode", (String)"id,bizobject,isautonextnode,isautoclose", (QFilter[])nodeFilter.toArray());
        return bizNodeObj;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTemplate();
        this.createTabStatusPage();
        this.setVisiable();
        this.setSourceTypeEnable();
        IFormView view = this.getView();
        Object pkId = this.getModel().getDataEntity().getPkValue();
        this.cachePageId(view.getEntityId(), pkId, view.getPageId());
    }

    private void setSourceTypeEnable() {
        String sourceType;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (Objects.nonNull(parentView) && Objects.nonNull(sourceType = PdsCommonUtils.getCustomParams((IFormView)parentView))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"sourcetype"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "srctype": {
                IDataModel model = this.getModel();
                DynamicObject srcTypeObj = model.getDataEntity().getDynamicObject("srctype");
                if (null == srcTypeObj) {
                    model.deleteEntryData("entrysubflow");
                    model.deleteEntryData("entrymainflow");
                    model.deleteEntryData("tplentry");
                    break;
                }
                srcTypeObj = SrcTypeUtil.getSrcTypeObjById((Object)srcTypeObj.getPkValue());
                this.createEntryData(srcTypeObj);
                DynamicObject template = this.getCurrNodeTemplate(srcTypeObj);
                if (null != template) {
                    this.getModel().setValue("template", null);
                    this.getModel().setValue("template", template.getPkValue());
                } else {
                    this.getModel().setValue("template", null);
                }
                this.createTplentryBySrcType(srcTypeObj);
                this.createTabStatusPage();
                DynamicObject dataObj = this.getModel().getDataEntity();
                String nodeName = this.getTitle(dataObj.getPkValue(), dataObj.getDataEntityType().getName());
                this.getView().setFormTitle(new LocaleString(nodeName));
                break;
            }
        }
    }

    private void createEntryData(DynamicObject srcTypeObj) {
        DynamicObjectCollection entryNodeCols = srcTypeObj.getDynamicObjectCollection("entrynode");
        int entryNodeSize = entryNodeCols.size();
        IDataModel model = this.getModel();
        model.deleteEntryData("entrymainflow");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entrymainflow");
        if (null == entryGrid) {
            return;
        }
        for (int i = 0; i < entryNodeSize; ++i) {
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            model.createNewEntryRow("entrymainflow");
            entryGrid.selectRows(i);
            this.setEntryVal(entryNodeCol, i);
            DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("subentrynode");
            this.createSubEntryData(subEntryCols);
        }
    }

    private void setEntryVal(DynamicObject col, int rowIndex) {
        DynamicObject template;
        IDataModel model = this.getModel();
        DynamicObject bizNodeObj = col.getDynamicObject("biznode");
        if (null != bizNodeObj) {
            model.setValue("biznode", bizNodeObj.getPkValue(), rowIndex);
        }
        if (null != (template = col.getDynamicObject("template"))) {
            model.setValue("comptemplate", col.getDynamicObject("template").getPkValue(), rowIndex);
        }
        model.setValue("isflowchart", col.get("isflowchart"), rowIndex);
        model.setValue("bizobject", col.get("bizobject"), rowIndex);
        model.setValue("extobject", col.get("extobject"), rowIndex);
        model.setValue("nodename", col.get("nodename"), rowIndex);
    }

    private void createSubEntryData(DynamicObjectCollection cols) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entrysubflow");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject col : cols) {
            DynamicObject template;
            DynamicObject bizNodeObj = col.getDynamicObject("subbiznode");
            if (null != bizNodeObj) {
                ts.set("subbiznode", bizNodeObj.getPkValue(), i);
            }
            if (null != (template = col.getDynamicObject("subtemplate"))) {
                ts.set("subcomptemplate", template.getPkValue(), i);
            }
            ts.set("subisaudit", col.get("subisaudit"), i);
            ts.set("subisflowchart", col.get("subisflowchart"), i);
            ts.set("subbizobject", col.get("subbizobject"), i);
            ts.set("subextobject", col.get("subextobject"), i);
            ts.set("subnodename", col.get("subnodename"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entrysubflow", ts);
    }

    private void createTplentryBySrcType(DynamicObject srcTypeObj) {
        Object[] objs;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        model.deleteEntryData("tplentry");
        List templateIDList = SrcProjectUtil.getTemplateIDBySrcType((DynamicObject)srcTypeObj);
        DynamicObject tplObj = BusinessDataServiceHelper.newDynamicObject((String)"pds_tplconfig");
        for (Object obj : objs = BusinessDataServiceHelper.load((Object[])templateIDList.toArray(new Object[0]), (IDataEntityType)tplObj.getDataEntityType())) {
            DynamicObject compTpl = (DynamicObject)obj;
            DynamicObjectCollection compEntryCols = compTpl.getDynamicObjectCollection("compentry");
            for (DynamicObject col : compEntryCols) {
                DynamicObject component;
                ts.set("tmp_template", compTpl.getPkValue(), i);
                String bizObj = col.getString("bizobject");
                if (null != bizObj) {
                    ts.set("tmp_bizobject", (Object)bizObj, i);
                }
                if (null != (component = col.getDynamicObject("component"))) {
                    ts.set("tmp_component", component.getPkValue(), i);
                }
                ++i;
            }
        }
        model.batchCreateNewEntryRow("tplentry", ts);
    }

    private DynamicObject getCurrNodeTemplate(DynamicObject srcTypeObj) {
        DynamicObjectCollection entryNodeCols = srcTypeObj.getDynamicObjectCollection("entrynode");
        int entryNodeSize = entryNodeCols.size();
        DynamicObject template = null;
        String entityKey = this.getView().getEntityId();
        for (int i = 0; i < entryNodeSize; ++i) {
            String bizObjNum;
            DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(i);
            DynamicObject bizNode = entryNodeCol.getDynamicObject("biznode");
            DynamicObject bizObject = bizNode.getDynamicObject("bizobject");
            if (null == bizObject || !entityKey.equals(bizObjNum = bizObject.getString("number")) || null == (template = entryNodeCol.getDynamicObject("template"))) continue;
            return template;
        }
        return template;
    }

    private void setTemplate() {
        DynamicObject srcTypeObj = this.getModel().getDataEntity().getDynamicObject("srctype");
        DynamicObject temObj = this.getModel().getDataEntity().getDynamicObject("template");
        String entityKey = this.getView().getEntityId();
        if (srcTypeObj != null && temObj == null && "src_project".equals(entityKey)) {
            srcTypeObj = SrcTypeUtil.getSrcTypeObjById((Object)srcTypeObj.getPkValue());
            this.createEntryData(srcTypeObj);
            DynamicObject template = this.getCurrNodeTemplate(srcTypeObj);
            if (null != template) {
                this.getModel().setValue("template", template.getPkValue());
            } else {
                this.getModel().setValue("template", null);
            }
            this.createTplentryBySrcType(srcTypeObj);
        }
    }

    private void createTabStatusPage() {
        Wizard wizard = (Wizard)this.getControl("status_wizardap");
        List stepsOptions = wizard.getStepsOptions();
        stepsOptions.clear();
        IDataModel model = this.getModel();
        Object srcTypeObj = model.getValue("srctype");
        if (null == srcTypeObj) {
            return;
        }
        DynamicObject obj = model.getDataEntity(true);
        boolean isHandle = false;
        boolean isEnd = false;
        String bizStatus = obj.getString("bizstatus");
        if (SrcBizStatusEnum.ENDED.getVal().equals(bizStatus) || SrcBizStatusEnum.DISCARD.getVal().equals(bizStatus) || SrcProjectUtil.isEnded((DynamicObject)obj)) {
            isEnd = true;
        }
        IPageCache cache = this.getPageCache();
        HashMap<String, String> pageIdMap = new HashMap<String, String>(8);
        DynamicObjectCollection nodeCols = obj.getDynamicObjectCollection("entrymainflow");
        String processingNodeIndex = null;
        String cacheNodeIndex = null;
        int nodeIndex = 0;
        DynamicObject currNode = obj.getDynamicObject("currentnode");
        for (DynamicObject nodeCol : nodeCols) {
            String bizObject = null;
            DynamicObject bizNode = null;
            bizNode = nodeCol.getDynamicObject("biznode");
            if (null == bizNode) continue;
            String bizNodeId = bizNode.getPkValue().toString();
            cacheNodeIndex = (String)pageIdMap.get(bizNodeId);
            if (null == cacheNodeIndex) {
                StepsOption stepOpiton;
                if (null != pageIdMap.get(bizNodeId) || null == (stepOpiton = this.createStepOption(nodeCol))) continue;
                stepsOptions.add(stepOpiton);
                bizObject = bizNode.getDynamicObject("bizobject").getString("number");
                pageIdMap.put(this.getStepCacheKey(nodeIndex), bizObject);
                pageIdMap.put(bizNodeId, String.valueOf(nodeIndex));
                ++nodeIndex;
            }
            bizStatus = nodeCol.getString("flowbizstatus");
            if (SrcBizStatusEnum.PROCESSING.getVal().equals(bizStatus)) {
                if (null == processingNodeIndex) {
                    processingNodeIndex = String.valueOf(nodeIndex);
                }
            } else if (SrcBizStatusEnum.HANDLED.getVal().equals(bizStatus) || SrcBizStatusEnum.ENDED.getVal().equals(bizStatus)) {
                isHandle = true;
            } else if (null != currNode && currNode.getDynamicObject("bizobject").getString("number").equals(bizObject)) {
                processingNodeIndex = String.valueOf(nodeIndex);
            }
            DynamicObjectCollection subEntryCols = nodeCol.getDynamicObjectCollection("entrysubflow");
            for (DynamicObject subEntryCol : subEntryCols) {
                bizNode = subEntryCol.getDynamicObject("subbiznode");
                if (null == bizNode) continue;
                bizNodeId = bizNode.getPkValue().toString();
                cacheNodeIndex = (String)pageIdMap.get(bizNodeId);
                if (null == cacheNodeIndex) {
                    StepsOption stepOpiton;
                    if (null != pageIdMap.get(bizNodeId) || null == (stepOpiton = this.createStepOption(subEntryCol))) continue;
                    stepsOptions.add(stepOpiton);
                    bizObject = bizNode.getDynamicObject("bizobject").getString("number");
                    pageIdMap.put(this.getStepCacheKey(nodeIndex), bizObject);
                    pageIdMap.put(bizNodeId, String.valueOf(nodeIndex));
                    ++nodeIndex;
                }
                if (null != processingNodeIndex) continue;
                String subBizStatus = subEntryCol.getString("subflowbizstatus");
                boolean isAudit = subEntryCol.getBoolean("subisaudit");
                if (!isAudit || !SrcBizStatusEnum.PROCESSING.getVal().equals(subBizStatus)) continue;
                processingNodeIndex = String.valueOf(nodeIndex);
            }
        }
        StepsOption endOption = this.getEndStep();
        pageIdMap.put(String.valueOf(nodeIndex), END_PAGE);
        Object isshowfinished = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isshowfinished");
        boolean isShowEnd = true;
        if (null != isshowfinished && !((Boolean)isshowfinished).booleanValue()) {
            isShowEnd = false;
        }
        if (isEnd || isShowEnd) {
            stepsOptions.add(endOption);
        }
        if (pageIdMap.size() > 0) {
            cache.put(pageIdMap);
        }
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        int currentStep = 0;
        String currentStatus = "process";
        if (isEnd) {
            currentStep = stepsOptions.size();
            currentStatus = "error";
            endOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"SrcBidbillCompTplEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0])));
        } else if (null != processingNodeIndex) {
            currentStep = Integer.parseInt(processingNodeIndex);
        } else if (isHandle) {
            currentStep = stepsOptions.size();
            currentStatus = "finish";
        } else if (null == SrcBidCompTplUtil.getCurrNode((DynamicObject)obj, (boolean)false)) {
            currentStep = stepsOptions.size();
        }
        wizard.setWizardStepsOptions(stepsOptions);
        currentStepMap.put("currentStep", currentStep - 1);
        currentStepMap.put("currentStatus", currentStatus);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    public StepsOption getEndStep() {
        StepsOption endOption = new StepsOption();
        endOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"SrcBidbillCompTplEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0])));
        endOption.setDescription(new LocaleString(""));
        endOption.setStatus("finish");
        return endOption;
    }

    public StepsOption createStepOption(DynamicObject nodeCol) {
        DynamicObject bizNode = null;
        boolean isFlowChart = true;
        String nodeName = "";
        if (nodeCol.getDataEntityType() instanceof SubEntryType) {
            bizNode = nodeCol.getDynamicObject("subbiznode");
            isFlowChart = nodeCol.getBoolean("subisflowchart");
            nodeName = nodeCol.getString("subnodename");
        } else {
            bizNode = nodeCol.getDynamicObject("biznode");
            isFlowChart = nodeCol.getBoolean("isflowchart");
            nodeName = nodeCol.getString("nodename");
        }
        if (!isFlowChart) {
            return null;
        }
        if (null == bizNode) {
            return null;
        }
        if (StringUtils.isEmpty((String)nodeName)) {
            nodeName = bizNode.getString("name");
        }
        StepsOption option = new StepsOption();
        option.setTitle(new LocaleString(nodeName));
        option.setDescription(new LocaleString(""));
        String entityKey = this.getView().getEntityId();
        DynamicObject bizObj = bizNode.getDynamicObject("bizobject");
        if (null != bizObj && bizObj.getString("number").equals(entityKey)) {
            nodeName = String.format(ResManager.loadKDString((String)"%1$s(\u5f53\u524d\u9875)", (String)"SrcBidbillCompTplEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0]), nodeName);
            option.setStatus("finish");
            option.setTitle(new LocaleString(nodeName));
        } else {
            option.setStatus("finish");
        }
        option.setStatus("finish");
        return option;
    }

    private void setVisiable() {
        IFormView view = this.getView();
        Control fs_flowinfo = view.getControl("fs_flowinfo");
        if (null != fs_flowinfo) {
            DynamicObject nextNode = PdsFlowConfigUtils.getChildrenNode((DynamicObject)this.getModel().getDataEntity(true), (boolean)false);
            if (null == nextNode) {
                view.setVisible(Boolean.FALSE, new String[]{"nextnode"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"nextnode"});
            }
        }
    }

    public void update(StepEvent setpEvent) {
        int stepVal = setpEvent.getValue();
        IPageCache cache = this.getPageCache();
        String entityKey = cache.get(this.getStepCacheKey(stepVal));
        if (null == entityKey) {
            return;
        }
        String currEntityKey = this.getView().getEntityId();
        if (entityKey.equals(currEntityKey)) {
            return;
        }
        if (!END_PAGE.equals(entityKey)) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            DynamicObject currNode = SrcBidCompTplUtil.getCurrNode((DynamicObject)obj, (String)entityKey, (boolean)false);
            this.showNode(currNode, false);
        }
    }

    private String getStepCacheKey(int stepVal) {
        return "wizardap_step_" + stepVal;
    }
}

