/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.botp.jobtask.BackgroundTaskManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.src.common.contract.SrcContractUtils;
import kd.scm.src.formplugin.ext.SrcContractToEasMaterialValidator;
import kd.scm.src.formplugin.ext.SrcContractToEasOrderCloseCallBack;
import kd.scm.src.formplugin.ext.SrcContractToOrderBotp;
import kd.scm.src.formplugin.ext.SrcContractToOrderCloseCallBack;
import kd.scm.src.formplugin.ext.SrcContractToOrderValidator;
import kd.scm.src.formplugin.ext.SrcContractToXhOrderValidator;

public class SrcContractToOrderEdit
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(SrcContractToOrderEdit.class);
    private String srcBill = "src_contract";
    private String tarBill = "pm_purorderbill";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ApiConfigUtil.hasXKScmConfig()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toorder"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pricelist"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"generate"});
        }
        if (!ApiConfigUtil.hasEASScmConfig()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toeasorder"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toeaspricelist"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toeascontract"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"eas_generate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        boolean isFAJB = "SYS002".equals(this.getModel().getDataEntity().getString("srctype.number"));
        switch (key) {
            case "toorder": {
                SrcContractToOrderValidator validator = (SrcContractToOrderValidator)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToOrderValidator.class.getSimpleName());
                if (validator == null || !"XK".equals(validator.validate(this.getView(), args)) || args.isCancel()) break;
                operate.getParameter().put("src_source", "XK");
                break;
            }
            case "toeasorder": {
                SrcContractToOrderValidator easvalidator = (SrcContractToOrderValidator)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToOrderValidator.class.getSimpleName());
                if (easvalidator != null && "EAS".equals(easvalidator.validate(this.getView(), args)) && !args.isCancel()) {
                    operate.getParameter().put("src_source", "EAS");
                }
                SrcContractToEasMaterialValidator materialValidator = (SrcContractToEasMaterialValidator)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToEasMaterialValidator.class.getSimpleName());
                if (args.isCancel() || materialValidator == null) break;
                materialValidator.validate(this.getView(), args);
                break;
            }
            case "toxhorder": {
                DynamicObjectCollection entryentity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                ArrayList selectedRowList = new ArrayList();
                DynamicObjectCollection rows = SrcContractUtils.getSelectRows((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObjectCollection)entryentity, selectedRowList);
                SrcContractToXhOrderValidator xhValidator = (SrcContractToXhOrderValidator)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToXhOrderValidator.class.getSimpleName());
                if (xhValidator == null) break;
                xhValidator.validate(this.getView(), args, rows, isFAJB);
                break;
            }
        }
    }

    private void pushXhOrder() {
        ArrayList<ConvertOperationResult> results = new ArrayList<ConvertOperationResult>();
        DynamicObjectCollection entryentity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject entity = this.getView().getModel().getDataEntity(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        DynamicObjectCollection rows = SrcContractUtils.getSelectRows((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObjectCollection)entryentity, selectedRowList);
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            long entryId = row.getLong("id");
            entryIdList.add(entryId);
        }
        PushArgs args = new PushArgs();
        args.setTargetEntityNumber(this.tarBill);
        args.setHasRight(false);
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setAutoSave(false);
        args.setBuildConvReport(true);
        QFilter idFilter = new QFilter("id", "=", (Object)entity.getLong("id"));
        QFilter entryIdFilter = new QFilter("entryentity.id", "in", entryIdList);
        DynamicObjectCollection sourceInfo = this.getSourceInfo(idFilter.and(entryIdFilter));
        if (rows.size() != 0 && "2".equals(((DynamicObject)rows.get(0)).getString("reqsource"))) {
            args.setSourceEntityNumber("pm_purapplybill");
            HashMap<String, Map<String, Object>> propertyMap = new HashMap<String, Map<String, Object>>();
            Map<String, List<ListSelectedRow>> rowsMap = this.wrapRowsMapInfos(sourceInfo, propertyMap);
            Set<Map.Entry<String, List<ListSelectedRow>>> entries = rowsMap.entrySet();
            Iterator<Map.Entry<String, List<ListSelectedRow>>> iterator = entries.iterator();
            ArrayList<ConvertOperationResult> successResult = new ArrayList<ConvertOperationResult>();
            while (iterator.hasNext()) {
                Map.Entry<String, List<ListSelectedRow>> next = iterator.next();
                List<ListSelectedRow> value = next.getValue();
                if (value == null || value.size() <= 0) continue;
                Map propertyInfos = (Map)propertyMap.get(next.getKey());
                PushArgs pushArgs = this.getPushArgs(propertyInfos, args);
                pushArgs.setSelectedRows(value);
                ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
                if (result.isSuccess()) {
                    successResult.add(result);
                    continue;
                }
                results.add(result);
            }
            this.dealResult(successResult, results, args);
        } else {
            for (DynamicObject row : rows) {
                ListSelectedRow selectedRow = new ListSelectedRow();
                selectedRow.setPrimaryKeyValue(this.getModel().getDataEntity().getPkValue());
                selectedRow.setEntryEntityKey("entryentity");
                selectedRow.setEntryPrimaryKeyValue(row.getPkValue());
                selectedRowList.add(selectedRow);
            }
            PushArgs pushArg = this.getPushArg(selectedRowList, this.srcBill, this.tarBill);
            if (selectedRowList.size() <= 20000) {
                ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArg);
                if (result.isSuccess() && result.getCachePageIds().size() + result.getTargetBillIds().size() != 0) {
                    if (result.getCachePageIds().size() + result.getTargetBillIds().size() == 1) {
                        Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushArg, (ConvertOperationResult)result, (boolean)false);
                    } else {
                        Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushArg, (ConvertOperationResult)result, (boolean)false);
                    }
                } else {
                    Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArg, (ConvertOperationResult)result);
                }
            } else {
                pushArg.setShowReport(true);
                this.pushAndSaveBackGround(pushArg);
            }
        }
    }

    private void dealResult(List<ConvertOperationResult> successResult, List<ConvertOperationResult> results, PushArgs args) {
        if (successResult.size() > 0) {
            results.clear();
            results.addAll(successResult);
        }
        ConvertOperationResult mergeResult = new ConvertOperationResult();
        if (results.size() > 0) {
            mergeResult = results.get(0);
            for (ConvertOperationResult result : results) {
                if (mergeResult == result) continue;
                mergeResult.setMessage(mergeResult.getMessage() + result.getMessage());
                mergeResult.setSuccess(mergeResult.isSuccess() && result.isSuccess());
                mergeResult.getCachePageIds().addAll(result.getCachePageIds());
                mergeResult.getCacheTargetObjStr().putAll(result.getCacheTargetObjStr());
                mergeResult.getTargetBillIds().addAll(result.getTargetBillIds());
                mergeResult.getDataMutexSrcBillIds().addAll(result.getDataMutexSrcBillIds());
                mergeResult.getBillReports().addAll(result.getBillReports());
                mergeResult.setFinishedTime(result.getFinishedTime());
            }
        }
        if (!mergeResult.isSuccess() || mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)mergeResult);
        } else if (mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)this.getView(), (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)false);
        } else {
            Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)false);
        }
    }

    private DynamicObjectCollection getSourceInfo(QFilter qFilter) {
        String sb = "biztype,taxtype,entryentity.id,entryentity.entry_org,entryentity.supplier,entryentity.currency,entryentity.exratedate,entryentity.exratetable,entryentity.quotation,entryentity.sourcebillid,entryentity.sourceentryid";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_contract", (String)sb, (QFilter[])new QFilter[]{qFilter}, null);
        return rows;
    }

    private PushArgs getPushArgs(Map<String, Object> propertyInfos, PushArgs args) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(args.getTargetEntityNumber());
        pushArgs.setSourceEntityNumber(args.getSourceEntityNumber());
        pushArgs.setAutoSave(args.isAutoSave());
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(args.isBuildConvReport());
        pushArgs.getCustomParams().put("formId", "src_contract");
        pushArgs.getCustomParams().put("issuppcolla", "true");
        pushArgs.getCustomParams().put("invokebizservice", "wrapOrder4src");
        pushArgs.getCustomParams().put("data", SerializationUtils.toJsonString(propertyInfos));
        return pushArgs;
    }

    private Map<String, List<ListSelectedRow>> wrapRowsMapInfos(DynamicObjectCollection rows, Map<String, Map<String, Object>> propertyMap) {
        HashMap<String, List<ListSelectedRow>> rowsMap = new HashMap<String, List<ListSelectedRow>>();
        for (DynamicObject contractColl : rows) {
            String splitType = this.makeRowKey(contractColl);
            ArrayList<ListSelectedRow> listSelectedRows = (ArrayList<ListSelectedRow>)rowsMap.get(splitType);
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)contractColl.getLong("entryentity.sourcebillid"));
            row.setEntryEntityKey("billentry");
            row.setEntryPrimaryKeyValue((Object)contractColl.getLong("entryentity.sourceentryid"));
            this.wrapPropertyMap(splitType, propertyMap, contractColl);
            if (listSelectedRows != null) {
                listSelectedRows.add(row);
                continue;
            }
            listSelectedRows = new ArrayList<ListSelectedRow>();
            listSelectedRows.add(row);
            rowsMap.put(splitType, listSelectedRows);
        }
        return rowsMap;
    }

    private PushArgs getPushArg(List<ListSelectedRow> selectedRowList, String srcBill, String tarBill) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcBill);
        pushArgs.setTargetEntityNumber(tarBill);
        pushArgs.setBuildConvReport(false);
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.setAutoSave(true);
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(false);
        pushArgs.getCustomParams().put("formId", "src_contract");
        return pushArgs;
    }

    private void wrapPropertyMap(String splitType, Map<String, Map<String, Object>> propertyMap, DynamicObject compareColl) {
        Map valuesMap = propertyMap.computeIfAbsent(splitType, k -> new HashMap());
        valuesMap.put(compareColl.getString("entryentity.sourceentryid"), compareColl.getLong("entryentity.id"));
    }

    private String makeRowKey(DynamicObject contractColl) {
        String biztype = contractColl.getString("biztype");
        String entrypurorg = contractColl.getString("entryentity.entry_org");
        String supplier = contractColl.getString("entryentity.supplier");
        String currency = contractColl.getString("entryentity.currency");
        String exratedate = contractColl.getString("entryentity.exratedate");
        String exratetable = contractColl.getString("entryentity.exratetable");
        String quotation = contractColl.getString("entryentity.quotation");
        StringBuilder sb = new StringBuilder();
        sb.append(biztype).append("|").append(entrypurorg).append("|").append(supplier).append("|").append(currency).append("|").append(exratedate).append("|").append(exratetable).append("|").append(quotation);
        return sb.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        super.afterDoOperation(args);
        switch (key) {
            case "toorder": 
            case "toeasorder": {
                SrcContractToOrderBotp botp;
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                String srcSource = (String)operate.getParameter().get("src_source");
                if ("EAS".equals(srcSource)) {
                    SrcContractToOrderBotp botp2 = (SrcContractToOrderBotp)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToOrderBotp.class.getSimpleName());
                    if (botp2 == null) break;
                    botp2.openBotp(this, this.getView());
                    break;
                }
                if (!"XK".equals(srcSource) || (botp = (SrcContractToOrderBotp)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToOrderBotp.class.getSimpleName())) == null) break;
                botp.openBotp(this, this.getView());
                break;
            }
            case "toxhorder": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.pushXhOrder();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evet) {
        String actionId;
        super.closedCallBack(evet);
        switch (actionId = evet.getActionId()) {
            case "botpList": {
                SrcContractToEasOrderCloseCallBack eascallBack;
                if (ApiConfigUtil.hasXKScmConfig()) {
                    SrcContractToOrderCloseCallBack callBack = (SrcContractToOrderCloseCallBack)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToOrderCloseCallBack.class.getSimpleName());
                    if (callBack == null) break;
                    callBack.callBack(this, evet);
                    break;
                }
                if (!ApiConfigUtil.hasEASScmConfig() || (eascallBack = (SrcContractToEasOrderCloseCallBack)ExtPluginFactory.getInstance().getExtPluginInstance(SrcContractToEasOrderCloseCallBack.class.getSimpleName())) == null) break;
                eascallBack.callBack(this, evet);
                break;
            }
        }
    }

    private void pushAndSaveBackGround(PushArgs args) {
        BackgroundTaskManager pushAndSaveJob = BackgroundTaskManager.newInstance((IFormView)this.getView());
        pushAndSaveJob.dispatchBackgroundTask(args);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u6570\u91cf\u8d85\u8fc720000\u6761, \u5df2\u8f6c\u540e\u53f0\u6267\u884c\u3002", (String)"SrcContractToOrderEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
    }
}

