/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcEvaluateUtils;

public class SrcExpertEvaluateEdit
extends AbstractBillPlugIn {
    private boolean isChanging = false;

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.setDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SrcEvaluateUtils.setPushButtonVisible((IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                PdsCommonUtils.setBillNo((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String key;
        super.propertyChanged(evt);
        switch (key = evt.getProperty().getName()) {
            case "period": 
            case "datefrom": 
            case "dateto": {
                this.calculateDate(evt);
                break;
            }
        }
    }

    private void setDefaultValue() {
        boolean isChanged = false;
        if (this.getModel().getValue("template") == null) {
            TemplateUtil.setDefaultTemplate((IDataModel)this.getModel(), (String)PdsBizNodeEnums.EVALUATE.getValue());
            isChanged = true;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            isChanged = true;
        }
        if (isChanged) {
            this.getModel().setDataChanged(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("basetype", "8");
        switch (opKey) {
            case "save": {
                SrcEvaluateUtils.setPushButtonVisible((IFormView)this.getView());
                break;
            }
            case "pushevaluate": {
                if (null == result || !result.isSuccess()) break;
                SrcEvaluateUtils.pushEvaluateTask((IFormView)this.getView(), Collections.emptyList());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unpushevaluate": {
                if (null == result || !result.isSuccess()) break;
                SrcEvaluateUtils.unPushEvaluateTask((IFormView)this.getView());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "evaluatehelper": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("project", projectId);
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_evaluateassist", (ShowType)ShowType.MainNewTabPage, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "scorehelper"));
                break;
            }
            case "evaluateanalyse": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                    OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_evaluateanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qFilter, null);
                    break;
                }
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_evaluateanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
                break;
            }
            case "delete": {
                SrcEvaluateUtils.deleteEvaluateTask((IFormView)this.getView());
                break;
            }
            case "audit": {
                long billId = this.getView().getModel().getDataEntity().getLong("id");
                DynamicObject[] cols = BusinessDataServiceHelper.load((String)"src_evaluateresultf7", (String)"id,scoretask", (QFilter[])new QFilter("billid", "=", (Object)billId).toArray());
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationServiceHelper.executeOperate((String)"evaluateresultsendmsg", (String)"src_evaluateresultf7", (DynamicObject[])cols, (OperateOption)option);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "scorehelper": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void calculateDate(PropertyChangedArgs evt) {
        if (this.isChanging) {
            return;
        }
        Object valueObj = this.getModel().getDataEntity().get("period.paramvalue");
        if (StringUtils.isBlank((Object)valueObj)) {
            return;
        }
        int months = Integer.parseInt(valueObj.toString());
        if (months == 0) {
            return;
        }
        this.isChanging = true;
        switch (evt.getProperty().getName()) {
            case "datefrom": {
                if (null == this.getModel().getDataEntity().getDate("datefrom")) break;
                Date dateTo = DateUtil.addMonth((Date)this.getModel().getDataEntity().getDate("datefrom"), (int)months);
                this.getModel().setValue("dateto", (Object)DateUtil.addDays((Date)dateTo, (int)-1));
                break;
            }
            case "dateto": {
                if (null == this.getModel().getDataEntity().getDate("dateto")) break;
                Date dateFrom = DateUtil.addMonth((Date)this.getModel().getDataEntity().getDate("dateto"), (int)(-months));
                this.getModel().setValue("datefrom", (Object)DateUtil.addDays((Date)dateFrom, (int)1));
                break;
            }
            case "period": {
                if (null != this.getModel().getDataEntity().getDate("datefrom")) {
                    Date dateTo = DateUtil.addMonth((Date)this.getModel().getDataEntity().getDate("datefrom"), (int)months);
                    this.getModel().setValue("dateto", (Object)DateUtil.addDays((Date)dateTo, (int)-1));
                    break;
                }
                if (null == this.getModel().getDataEntity().getDate("dateto")) break;
                Date dateFrom = DateUtil.addMonth((Date)this.getModel().getDataEntity().getDate("dateto"), (int)(-months));
                this.getModel().setValue("datefrom", (Object)DateUtil.addDays((Date)dateFrom, (int)1));
                break;
            }
        }
        this.isChanging = false;
    }
}

