/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.SrcCommonValidatorHelper;

public class SrcNotifySupplierEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDefaultValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.doOpVerify(evt, operateKey);
                break;
            }
        }
    }

    public void doOpVerify(BeforeDoOperationEventArgs evt, String operateKey) {
        DynamicObject billObj = this.getNotifyBillObj();
        if (null == billObj) {
            evt.setCancel(true);
            return;
        }
        String message = SrcCommonValidatorHelper.validate((DynamicObject)billObj, (String)"pds_noticesupplier", (String)operateKey, null, null);
        if (message != null && message.length() > 0) {
            evt.setCancel(true);
            evt.setCancelMessage(message);
            this.getView().showTipNotification(message);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "unaudit": {
                    this.doOperate(this.getNotifyBillObj(), operateKey);
                    break;
                }
            }
        }
    }

    public void doOperate(DynamicObject billObj, String operateKey) {
        PdsCommonUtils.doOperation((DynamicObject)billObj, (String)operateKey);
    }

    public DynamicObject getNotifyBillObj() {
        QFilter qfilter = TemplateUtil.getComponentQfilter((Object)this.getModel().getDataEntity().getPkValue(), (String)this.getView().getEntityId(), (String)"src_notifycomp");
        DynamicObject compData = QueryServiceHelper.queryOne((String)"src_notifycomp", (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (null == compData) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)compData.getLong("id"), (String)"pds_noticesupplier");
    }

    private void setDefaultValue() {
        boolean isChanged = false;
        if (this.getModel().getValue("template") == null) {
            if ("src_notifysupplier".equals(this.getView().getEntityId())) {
                TemplateUtil.setDefaultTemplate((IDataModel)this.getModel(), (String)PdsBizNodeEnums.NOTIFY.getValue());
            } else {
                TemplateUtil.setDefaultTemplate((IDataModel)this.getModel(), (String)PdsBizNodeEnums.WINNOTIFY.getValue());
            }
            isChanged = true;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            isChanged = true;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("bizstatus"))) {
            this.getModel().setValue("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
            isChanged = true;
        }
        if (isChanged) {
            this.getModel().setDataChanged(true);
        }
    }
}

