/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcPreProjectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        super.propertyChanged(evt);
        switch (fieldKey = evt.getProperty().getName()) {
            case "billno": 
            case "bidname": 
            case "org_tmp": 
            case "srctype": {
                PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView(), (String)"org_tmp", Collections.singletonList("src_demand_comp"));
                break;
            }
            case "source": {
                this.reloadDemandComp(evt);
                this.getView().invokeOperation("reloadcomp");
                break;
            }
            case "biztype": {
                SrcProjectUtil.resetSoureFlow((IFormView)this.getView(), (PropertyChangedArgs)evt);
                break;
            }
        }
    }

    public void reloadDemandComp(PropertyChangedArgs evt) {
        DynamicObject demandObj;
        DynamicObject valueObj;
        if (null != evt.getChangeSet()[0].getOldValue()) {
            valueObj = (DynamicObject)evt.getChangeSet()[0].getOldValue();
            demandObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)valueObj), (String)"src_demand", (String)"parentid,pentitykey,entitykey");
            this.setDemandCompValue(demandObj, 0L, null, null);
        }
        if (null != evt.getChangeSet()[0].getNewValue()) {
            valueObj = (DynamicObject)evt.getChangeSet()[0].getNewValue();
            demandObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)valueObj), (String)"src_demand", (String)"parentid,pentitykey,entitykey");
            this.setDemandCompValue(demandObj, SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()), "src_preproject", "src_demand_comp");
        }
    }

    public void setDemandCompValue(DynamicObject demandObj, long praentId, String pentityKey, String entityKey) {
        demandObj.set("parentid", (Object)praentId);
        demandObj.set("pentitykey", (Object)pentityKey);
        demandObj.set("entitykey", (Object)entityKey);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)demandObj);
    }

    public void registerListener(EventObject e) {
        BasedataEdit source;
        BasedataEdit srcType;
        super.registerListener(e);
        BasedataEdit sourcetype = (BasedataEdit)this.getControl("sourcetype");
        if (Objects.nonNull(sourcetype)) {
            sourcetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(srcType = (BasedataEdit)this.getControl("srctype"))) {
            srcType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(source = (BasedataEdit)this.getControl("source"))) {
            source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        SrcProjectUtil.getManageTypeComboByTenderType((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView());
        SrcProjectUtil.setBizTypeDefaultValue((IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.setDefaultValue();
                break;
            }
        }
    }

    public void setDefaultValue() {
        String bizStatus;
        DynamicObject billObj = this.getModel().getDataEntity();
        PdsCommonUtils.setBillNo((String)this.getView().getEntityId(), (DynamicObject)billObj);
        this.getModel().setValue("sourcetype", (Object)billObj.getLong("srctype.sourcetype.id"));
        this.getModel().setValue("sourceclass", (Object)billObj.getLong("srctype.sourceclass.id"));
        if (StringUtils.isBlank((Object)this.getModel().getValue("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        }
        if (StringUtils.isBlank((CharSequence)(bizStatus = billObj.getString("bizstatus"))) || ProcessStatusEnums.NOTSTARTED.getValue().equals(bizStatus)) {
            this.getModel().setValue("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        }
        if (null == this.getModel().getValue("currentnode")) {
            this.getModel().setValue("currentnode", (Object)PdsBizNodeEnums.PREPROJECT.getId());
            this.getModel().setValue("currentnodename", billObj.get("currentnode.name"));
        }
        this.getModel().setValue("ispreproject", (Object)true);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "source": {
                this.setSourceSelect(evt);
                break;
            }
            case "srctype": {
                this.setSrctypeSelect(evt);
                break;
            }
        }
    }

    private void setSourceSelect(BeforeF7SelectEvent evt) {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity());
        long srctypeId = this.getModel().getDataEntity().getLong("srctype.id");
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("srctype2", "=", (Object)srctypeId);
        qfilter.and("srctype2", ">", (Object)0);
        qfilter.and(ExtFilterUtils.getStringFilter((String)"parentid", (String)String.valueOf(billId)));
        qfilter.and("entryentity.project", "=", (Object)0);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qfilter);
    }

    private void setSrctypeSelect(BeforeF7SelectEvent evt) {
        QFilter qfilter = new QFilter("entrynode.biznode", "=", (Object)PdsBizNodeEnums.PREPROJECT.getId());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qfilter);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        long sourcetypeId = this.getModel().getDataEntity().getLong("sourcetype.id");
        paramMap.put("sourcetype", sourcetypeId);
        paramMap.put("ismustinput", "1");
        SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"src_project_srctype_filter", paramMap);
    }
}

