/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.SrcCurrencyUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcProjectInfomationEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tecSchemeEdit = (BasedataEdit)this.getView().getControl("tecscheme");
        tecSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizSchemeEdit = (BasedataEdit)this.getView().getControl("bizscheme");
        bizSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit aptSchemeEdit = (BasedataEdit)this.getView().getControl("aptscheme");
        aptSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit negSchemeEdit = (BasedataEdit)this.getView().getControl("negscheme");
        negSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        switch (key = evt.getProperty().getName()) {
            case "aptscheme": 
            case "tecscheme": 
            case "bizscheme": {
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)parentView.getModel().getDataEntity(), (String)("src_openscheme_" + key.substring(0, 3)), null);
                break;
            }
            case "negscheme": {
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(), (String)"src_negscheme_filter", this.getNegSchemeParamMap());
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        List compKey;
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null || !PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        SrcAppCache.put((String)"baseinfopageid", (Object)this.getView().getPageId(), (IFormView)parentView);
        this.setSurplusAmount();
        this.setCurrency();
        this.setPurdesion();
        if (PdsCompConfigUtil.parentIsProject((IFormView)this.getView()) && PdsCompConfigUtil.isTemplateChanged((IFormView)this.getView())) {
            this.setDataBySource();
            ArrayList<String> defaultCompKeyList = new ArrayList<String>(1);
            defaultCompKeyList.add(this.getView().getEntityId());
            PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView().getParentView(), (String)"srctype", defaultCompKeyList);
            this.setDataByScene();
            this.setAmount();
        }
        if ((compKey = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true), (boolean)false)).contains("src_bidopen_config")) {
            FieldEdit ismanualscore = (FieldEdit)this.getView().getControl("ismanualscore");
            ismanualscore.setFieldKey(null);
            ismanualscore.setVisible("visible", false);
            FieldEdit isbizscore = (FieldEdit)this.getView().getControl("isbizscore");
            isbizscore.setFieldKey(null);
            isbizscore.setVisible("visible", false);
        }
        FieldEdit manageType = (FieldEdit)this.getView().getControl("managetype");
        manageType.setFieldKey(null);
        manageType.setVisible("visible", false);
        this.setTendencyTypeCombo(this.getView());
        this.setNegSchemeDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!PdsCommonUtils.isValidBillType((IFormView)this.getView().getParentView())) {
            return;
        }
        this.setBidOpenSchemeVisible();
        this.setNegSchemeVisible();
        if (SrcPurListUtil.checkPurlistStatus((IDataModel)this.getModel(), (String)BillStatusEnum.SUBMIT.getVal()) || SrcPurListUtil.checkPurlistStatus((IDataModel)this.getModel(), (String)BillStatusEnum.AUDIT.getVal())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxtype", "decisiontype"});
        }
    }

    private void setTendencyTypeCombo(IFormView view) {
        IFormView parentView = view.getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        HashMap<String, String> comboItemMap = new HashMap<String, String>(3);
        comboItemMap.put("1", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u964d\u4ef7", (String)"SrcProjectInfomationEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("2", ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52a0\u4ef7", (String)"SrcProjectInfomationEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        comboItemMap.put("3", ResManager.loadKDString((String)"\u5141\u8bb8\u52a0\u4ef7\u6216\u964d\u4ef7", (String)"SrcProjectInfomationEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0]));
        String sourceNumber = parentView.getModel().getDataEntity().getString("sourcetype.number");
        if (Objects.equals(sourceNumber, SourceTypeEnums.VIE.getValue())) {
            comboItemMap.remove("2");
        } else if (Objects.equals(sourceNumber, SourceTypeEnums.ELECTRONIC_AUCTION.getValue())) {
            comboItemMap.remove("1");
        } else if (Objects.equals(sourceNumber, SourceTypeEnums.CONFIRM_PRICE.getValue())) {
            comboItemMap.remove("1");
            comboItemMap.remove("2");
        }
        ComboEdit tendencyComboEdit = (ComboEdit)view.getControl("tendency");
        tendencyComboEdit.setComboItems(PdsMetadataUtil.buildPropComboItems(comboItemMap));
    }

    private void setCurrency() {
        DynamicObject currencyObject;
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        DynamicObject org = parentView.getModel().getDataEntity().getDynamicObject("org");
        if (Objects.isNull(org)) {
            return;
        }
        if (parentView.getEntityId().equals("src_project") && Objects.isNull(currencyObject = this.getModel().getDataEntity().getDynamicObject("currency"))) {
            this.getModel().setValue("currency", SrcCurrencyUtil.getBaseCurrIdByOrg((Object)SrmCommonUtil.getPkValue((DynamicObject)org)));
        }
    }

    private void setAmount() {
        IFormView parentView = this.getView().getParentView();
        if ("src_project".equals(parentView.getEntityId())) {
            DynamicObject source = parentView.getModel().getDataEntity().getDynamicObject("source");
            DynamicObject scene = parentView.getModel().getDataEntity().getDynamicObject("scene");
            if (source != null) {
                this.getModel().setValue("sourceamount", (Object)source.getBigDecimal("sumamount"));
                this.getModel().setValue("amount", (Object)source.getBigDecimal("sumtaxamount"));
            }
            if (scene != null) {
                this.getModel().setValue("sceneamount", (Object)scene.getBigDecimal("sceneamount"));
                this.getModel().setValue("scenetaxamount", (Object)scene.getBigDecimal("scenetaxamount"));
            }
        }
    }

    private void setSurplusAmount() {
        IFormView parentview = this.getView().getParentView();
        if (parentview == null) {
            return;
        }
        if ("src_project".equals(parentview.getEntityId()) || "src_bidpublish".equals(parentview.getEntityId())) {
            DynamicObject sourceObj = parentview.getModel().getDataEntity().getDynamicObject("source");
            if (sourceObj == null) {
                return;
            }
            this.getModel().setValue("sourceamount", (Object)sourceObj.getBigDecimal("sumamount"));
            this.getModel().setValue("amount", (Object)sourceObj.getBigDecimal("sumtaxamount"));
        }
    }

    private void setPurdesion() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (parentView.getEntityId().equals("src_project")) {
            Boolean purdesion = parentView.getModel().getDataEntity().getBoolean("purdecision");
            this.getModel().setValue("purdecision", (Object)purdesion);
        }
    }

    private void setDataBySource() {
        IFormView projectview = this.getView().getParentView();
        IDataModel projectModel = projectview.getModel();
        DynamicObject source = projectModel.getDataEntity().getDynamicObject("source");
        if (null == source) {
            return;
        }
        this.getModel().setValue("purdecision", (Object)source.getString("purdecision"));
        this.getModel().setValue("decisionbillno", (Object)source.getString("decidenumber"));
    }

    private void setDataByScene() {
        DynamicObjectCollection newScenecols;
        IFormView projectview = this.getView().getParentView();
        IDataModel projectModel = projectview.getModel();
        DynamicObject newSceneObject = projectModel.getDataEntity().getDynamicObject("scene");
        this.getModel().setValue("purdecision", projectModel.getValue("purdecision"));
        if (newSceneObject != null && (newScenecols = QueryServiceHelper.query((String)"src_demandscene", (String)"id,range", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(newSceneObject.getPkValue().toString()))})).size() > 0) {
            this.getModel().setValue("range", ((DynamicObject)newScenecols.get(0)).get("range"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] newdata = e.getChangeSet();
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        Date stopbiddate = null;
        Date opendate = null;
        Date replyDate = null;
        switch (fieldKey) {
            case "stopbiddate": {
                if (!this.verifyProjectValue()) {
                    return;
                }
                opendate = (Date)model.getValue("opendate");
                replyDate = (Date)model.getValue("replydate");
                stopbiddate = (Date)newdata[0].getNewValue();
                this.stopBidDateBeforeOpenDate(stopbiddate, opendate, replyDate, fieldKey);
                this.setParentFieldValue(fieldKey, newdata[0].getNewValue());
                break;
            }
            case "opendate": {
                stopbiddate = (Date)model.getValue("stopbiddate");
                opendate = (Date)newdata[0].getNewValue();
                replyDate = (Date)model.getValue("replydate");
                this.stopBidDateBeforeOpenDate(stopbiddate, opendate, replyDate, fieldKey);
                break;
            }
            case "amount": {
                this.setAmountToProject();
                break;
            }
            case "currency": {
                this.setNegSchemeDefaultValue();
            }
            case "decisiontype": 
            case "taxtype": {
                this.setParentFieldValue(fieldKey, newdata[0].getNewValue());
                this.setNegSchemeDefaultValue();
                break;
            }
            case "opentype": {
                this.setBidOpenSchemeVisible();
            }
            case "isopencontrol": {
                if (!parentView.getModel().getDataEntity().getString("billstatus").equals(BillStatusEnum.SAVE.getVal())) break;
                SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)"src_openscheme_tec", (String)"tecscheme", null);
                SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)"src_openscheme_biz", (String)"bizscheme", null);
                SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)"src_openscheme_apt", (String)"aptscheme", null);
                break;
            }
            case "sceneamount": 
            case "scenetaxamount": {
                this.setNegSchemeDefaultValue();
                break;
            }
        }
    }

    private void setParentFieldValue(String fieldName, Object newValue) {
        IFormView parentView = this.getView().getParentView();
        Control control = parentView.getControl(fieldName);
        if (null == control) {
            return;
        }
        parentView.getModel().setValue(fieldName, newValue);
        this.getView().sendFormAction(this.getView().getView(parentView.getPageId()));
    }

    private boolean verifyProjectValue() {
        StringBuilder sb = new StringBuilder();
        IFormView parentView = this.getView().getParentView();
        Object manageType = parentView.getModel().getValue("managetype");
        if (Objects.isNull(manageType) || StringUtils.isBlank((Object)manageType)) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ba1\u7406\u65b9\u5f0f\u3002\n", (String)"SrcProjectInfomationEdit_16", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(sb.toString());
            return false;
        }
        return true;
    }

    private void setAmountToProject() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if (!entityId.equals("src_project")) {
            return;
        }
        parentView.getModel().setValue("amount", this.getModel().getValue("amount"));
        parentView.getModel().setDataChanged(false);
        this.getView().sendFormAction(parentView);
    }

    private void stopBidDateBeforeOpenDate(Date stopbiddate, Date opendate, Date replyDate, String fieldKey) {
        int paramInt;
        StringBuilder message = new StringBuilder();
        Date currDate = TimeServiceHelper.now();
        Object paramObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"limitday");
        if (paramObj != null && (paramInt = Integer.parseInt(paramObj.toString())) != 0) {
            Calendar date = Calendar.getInstance();
            date.setTime(new Date());
            date.add(5, paramInt);
            if (stopbiddate != null && stopbiddate.before(date.getTime()) && "stopbiddate".equals(fieldKey)) {
                message.append(String.format(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u672c\u9879\u76ee\u6295\u6807\u65f6\u95f4\uff1c%1$s\u5929\u3002", (String)"SrcProjectInfomationEdit_11", (String)"scm-src-formplugin", (Object[])new Object[0]), paramInt));
            }
        }
        if (replyDate == null) {
            if (stopbiddate != null && !stopbiddate.after(currDate)) {
                message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\u3002", (String)"SrcProjectInfomationEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]), this.sdf.format(stopbiddate), this.sdf.format(currDate)));
                this.getModel().setValue("stopbiddate", null);
            }
        } else if (!(stopbiddate == null || stopbiddate.after(currDate) && stopbiddate.after(replyDate))) {
            message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\u548c\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%3$s)\u3002", (String)"SrcProjectInfomationEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]), this.sdf.format(stopbiddate), this.sdf.format(currDate), this.sdf.format(replyDate)));
            this.getModel().setValue("stopbiddate", null);
        }
        if (opendate != null && !opendate.after(currDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u6807\u65f6\u95f4(%1$s)\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\u3002", (String)"SrcProjectInfomationEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]), this.sdf.format(opendate), this.sdf.format(currDate)));
            this.getModel().setValue("opendate", null);
        }
        if (stopbiddate != null && opendate != null && !opendate.after(stopbiddate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u6807\u65f6\u95f4(%1$s)\u5e94\u5927\u4e8e \u6295\u6807\u622a\u6b62\u65f6\u95f4(%2$s)\u3002", (String)"SrcProjectInfomationEdit_15", (String)"scm-src-formplugin", (Object[])new Object[0]), this.sdf.format(opendate), this.sdf.format(stopbiddate)));
        }
        if (message != null && message.toString().trim().length() > 0) {
            this.getView().showMessage(message.toString());
        }
    }

    private void setBidOpenSchemeVisible() {
        boolean isOpenControl = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)this.getSourceFlowId(), (String)"isbidopencontrol", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getBillObj(false))));
        if (this.isSaveStatus()) {
            boolean isManualPublishVie = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)this.getSourceFlowId(), (String)"isManualPublishVie", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getBillObj(false))));
            this.getModel().setValue("isviepublish", (Object)isManualPublishVie);
            boolean isManualPublishBid = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)this.getSourceFlowId(), (String)"isManualPublishBid", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getBillObj(false))));
            this.getModel().setValue("isbidpublish", (Object)isManualPublishBid);
            this.getModel().setValue("isopencontrol", (Object)isOpenControl);
        }
        if (!isOpenControl) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tecscheme", "bizscheme", "aptscheme"});
            return;
        }
        String pentittyKey = this.getView().getParentView().getEntityId();
        if (!pentittyKey.equals("tnd_apply") && PdsFlowConfigUtils.existsSpecificNode((DynamicObject)this.getBillObj(true), (String)PdsBizNodeEnums.APTITUDEAUDIT.getValue())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"aptscheme"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aptscheme"});
            if (this.isSaveStatus()) {
                this.getModel().setValue("aptscheme", null);
            }
        }
        LocaleString tecschemeTitle = null;
        if (this.getModel().getDataEntity().getString("opentype").equals("2")) {
            tecschemeTitle = new LocaleString(ResManager.loadKDString((String)"\u5f00\u6280\u672f\u6807\u7ba1\u63a7\u65b9\u6848\u3002", (String)"SrcProjectInfomationEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizscheme"});
        } else {
            tecschemeTitle = new LocaleString(ResManager.loadKDString((String)"\u5f00\u6807\u7ba1\u63a7\u65b9\u6848", (String)"SrcProjectInfomationEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizscheme"});
            if (this.isSaveStatus()) {
                this.getModel().setValue("bizscheme", null);
            }
        }
        BasedataEdit tecscheme = (BasedataEdit)this.getView().getControl("tecscheme");
        tecscheme.setCaption(tecschemeTitle);
    }

    private void setNegSchemeVisible() {
        boolean isNeedNegotiateControl = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)this.getSourceFlowId(), (String)"isNeedNegotiateControl", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getBillObj(false))));
        if (isNeedNegotiateControl) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"negscheme"});
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"negscheme", (boolean)true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"negscheme"});
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"negscheme", (boolean)false);
        }
    }

    public void setNegSchemeDefaultValue() {
        boolean isNeedNegotiateControl;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (this.isSaveStatus() && (isNeedNegotiateControl = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)this.getSourceFlowId(), (String)"isNeedNegotiateControl", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)this.getBillObj(false)))))) {
            SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)this.getView().getModel().getDataEntity(), (String)"src_negscheme_filter", (String)"negscheme", this.getNegSchemeParamMap());
        }
    }

    public Map<String, Object> getNegSchemeParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("sourcetype", this.getView().getParentView().getModel().getDataEntity().getLong("sourcetype.id"));
        paramMap.put("srctype", this.getView().getParentView().getModel().getDataEntity().getLong("srctype.id"));
        paramMap.put("amount", this.getModel().getValue("sceneamount"));
        paramMap.put("taxamount", this.getModel().getValue("scenetaxamount"));
        paramMap.put("ismustinput", true);
        return paramMap;
    }

    private boolean isSaveStatus() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return false;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        return billObj.getString("billstatus").equals(BillStatusEnum.SAVE.getVal());
    }

    private long getSourceFlowId() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return 0L;
        }
        DynamicObject billObj = parentView.getModel().getDataEntity();
        return SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
    }

    private DynamicObject getBillObj(boolean isAll) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return null;
        }
        if (isAll) {
            return parentView.getModel().getDataEntity(true);
        }
        return parentView.getModel().getDataEntity();
    }
}

