/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.formplugin.edit.PdsChgCompReloadDataTpl;

public class SrcProjectManChgEdit
extends PdsChgCompReloadDataTpl
implements BeforeF7SelectListener {
    protected void reloadBillData() {
        this.setProjectCreator();
    }

    protected void reloadEntryData() {
        this.createEntryEntity();
    }

    private void createEntryEntity() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        DynamicObject projectManChgObj = TemplateUtil.getComponentData((String)String.valueOf(projectObj.getLong("id")), (String)"src_project_man");
        if (null == projectManChgObj) {
            return;
        }
        DynamicObjectCollection entryentity = projectManChgObj.getDynamicObjectCollection("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject entry : entryentity) {
            ts.set("bizrole", entry.get("bizrole.id"), i);
            ts.set("bidder", entry.get("bidder.id"), i);
            ts.set("srcentryid", entry.get("id"), i);
            ts.set("seq", (Object)(i + 1), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void setProjectCreator() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("project")), (String)"src_project");
        long projectCreatorId = projectObj.getLong("projectcreator.id");
        if (projectCreatorId != 0L) {
            model.setValue("projectcreator", (Object)projectCreatorId);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit newBidder;
        BasedataEdit newProjectCreator = (BasedataEdit)this.getView().getControl("newprojectcreator");
        if (newProjectCreator != null) {
            newProjectCreator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((newBidder = (BasedataEdit)this.getView().getControl("newbidder")) != null) {
            newBidder.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter().getShowParameter();
        switch (key) {
            case "newprojectcreator": {
                DynamicObject projectCreator = (DynamicObject)this.getModel().getValue("projectcreator");
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "!=", projectCreator.getPkValue()));
                break;
            }
            case "newbidder": {
                int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject bidder = (DynamicObject)this.getModel().getValue("bidder", currIndex);
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "!=", bidder.getPkValue()));
                break;
            }
        }
    }
}

