/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.carryvalue.PdsCarryValueFacade;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.enums.WinRuleEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.patternfilter.PatternFilterUtils;
import kd.scm.src.common.util.SrcAppCache;
import kd.scm.src.common.util.SrcDecisionUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcProjectWinruleEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit purListEdit;
        BasedataEdit schemeEdit;
        super.registerListener(e);
        BasedataEdit winruleEdit = (BasedataEdit)this.getView().getControl("winrule");
        if (null != winruleEdit) {
            winruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (schemeEdit = (BasedataEdit)this.getView().getControl("scheme"))) {
            schemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purListEdit = (BasedataEdit)this.getView().getControl("purlist"))) {
            purListEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                break;
            }
            case "submit": {
                this.validatePurlistByWinRule(evt);
                break;
            }
        }
    }

    private void setWinerQtyDefault() {
        Set sourceTypeSet;
        DynamicObject sourceType;
        IFormView paraneView = this.getView().getParentView();
        if (Objects.isNull(paraneView)) {
            return;
        }
        String entityId = paraneView.getEntityId();
        if (Objects.equals(entityId, "src_project") && Objects.nonNull(sourceType = paraneView.getModel().getDataEntity().getDynamicObject("sourcetype")) && (sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.NEGOTIATE_SOLE.getValue(), SourceTypeEnums.NEGOTIATE_SOLE2.getValue()})).contains(sourceType.getString("number"))) {
            this.getModel().setValue("winerqty", (Object)1);
        }
    }

    private void validatePurlistByWinRule(BeforeDoOperationEventArgs beforeDoOperation) {
        String ruleassess;
        if (beforeDoOperation.isCancel()) {
            return;
        }
        DynamicObject obj = this.getModel().getDataEntity();
        boolean isValidateQty = true;
        DynamicObject winRule = obj.getDynamicObject("winrule");
        if (null != winRule) {
            String number = winRule.getString("number");
            if (WinRuleEnums.PACKAGE_AMOUNT_LOW.getValue().equals(number) || WinRuleEnums.PACKAGE_AVERAGE_LOW.getValue().equals(number)) {
                isValidateQty = false;
            }
        }
        if ("2".equals(ruleassess = obj.getString("ruleassess")) || "3".equals(ruleassess)) {
            isValidateQty = false;
        }
        if (!isValidateQty && SrcPurListUtil.purlistQtyIsZero((DynamicObject)obj)) {
            beforeDoOperation.setCancel(true);
            beforeDoOperation.setCancelMessage(ResManager.loadKDString((String)"\u4e2d\u6807\u539f\u5219/\u5546\u52a1\u62a5\u4ef7\u8ba1\u7b97\u89c4\u5219\u4e0e\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff0c\u8bf7\u586b\u5199\u91c7\u8d2d\u6e05\u5355\u6570\u91cf\u3002", (String)"SrcProjectWinruleEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "winrule": {
                IFormView parentView = this.getView().getParentView();
                if (null == parentView) break;
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)parentView.getModel().getDataEntity(), (String)(this.getView().getEntityId() + '_' + "winrule"), null);
                break;
            }
            case "scheme": {
                QFilter schemeQFilter = PatternFilterUtils.getSchemeFilter((IFormView)this.getView());
                ListShowParameter schemeShowParameter = (ListShowParameter)evt.getFormShowParameter();
                schemeShowParameter.getListFilterParameter().setFilter(schemeQFilter);
                String orderBy = "matchfield desc,priority,modifytime desc";
                schemeShowParameter.getListFilterParameter().setOrderBy(orderBy);
                break;
            }
            case "purlist": {
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "not in", rows.stream().map(row -> row.getLong("purlist.id")).collect(Collectors.toSet())));
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView projectview = this.getView().getParentView();
        if (projectview == null) {
            return;
        }
        SrcAppCache.put((String)"winrulepageid", (Object)this.getView().getPageId(), (IFormView)projectview);
        if (!"src_project".equals(projectview.getEntityId())) {
            return;
        }
        IDataModel projectModel = projectview.getModel();
        this.setSourceType(projectModel);
        this.setPurlistStatus();
        this.setWinerQtyDefault();
        SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)(this.getView().getEntityId() + '_' + "winrule"), (String)"winrule", null);
        if (Objects.equals(projectModel.getDataEntity().getString("billstatus"), SrcProjectEnum.STAGING.getCode())) {
            PatternFilterUtils.setSchemeDefaultValue((IFormView)this.getView());
        }
        if (PdsCompConfigUtil.parentIsProject((IFormView)this.getView()) && PdsCompConfigUtil.isTemplateChanged((IFormView)this.getView())) {
            ArrayList<String> defaultCompKeyList = new ArrayList<String>(1);
            defaultCompKeyList.add(this.getView().getEntityId());
            PdsCarryValueFacade.carryValueToComponent((IFormView)this.getView().getParentView(), (String)"srctype", defaultCompKeyList);
        }
    }

    private void setPurlistStatus() {
        String billstatus = "";
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        DynamicObject purlistObj = QueryServiceHelper.queryOne((String)"src_purlist", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        if (purlistObj != null) {
            billstatus = purlistObj.getString("billstatus");
        }
        this.getModel().setValue("purlistStatus", (Object)billstatus);
    }

    private void setSourceType(IDataModel projectModel) {
        if (projectModel.getValue("sourcetype") != null) {
            this.getModel().setValue("sourcetype", projectModel.getDataEntity().get("sourcetype.id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "winrule": {
                this.clearSumTaxAmount(this.getView());
            }
            case "ruleassess": {
                PatternFilterUtils.setSchemeDefaultValue((IFormView)this.getView());
                break;
            }
            case "winerqty": 
            case "scheme": 
            case "ratiotype": {
                this.clearSumTaxAmount(this.getView());
                break;
            }
        }
    }

    private void clearSumTaxAmount(IFormView view) {
        IFormView parentView = view.getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (Objects.equals(parentView.getEntityId(), "src_decision") || Objects.equals(parentView.getEntityId(), "src_predecision")) {
            SrcDecisionUtil.clearSumTaxAmount((IFormView)view);
        }
    }

    public void afterBindData(EventObject e) {
        Object isratio_othObj;
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            // empty if block
        }
        if (Objects.nonNull(isratio_othObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isratio_oth")) && ((Boolean)isratio_othObj).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ratio_oth"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ratio_oth"});
        }
    }
}

