/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcPurListExchangeRateEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        int index = this.getModel().getEntryRowCount("entryentity") - 1;
        if (index >= 0) {
            BizLog.log((String)"###SrcPurListExchangeRateEdit afterCreateNewData setDefaultVal.");
            this.setDefaultValue(index, this.getDefaultRateTableId(), this.getDefaultCurrencyId());
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        if (Objects.equals(evt.getEntryProp().getName(), "entryentity")) {
            int index = evt.getInsertRow();
            if (index == -1) {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
            }
            if (index >= 0) {
                this.setDefaultValue(index, this.getDefaultRateTableId(), this.getDefaultCurrencyId());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                this.setDefaultValue();
                break;
            }
        }
    }

    private void setDefaultValue() {
        int count = this.getModel().getEntryRowCount("entryentity");
        long rateTableId = this.getDefaultRateTableId();
        long currencyId = this.getDefaultCurrencyId();
        for (int index = 0; index < count; ++index) {
            this.setDefaultValue(index, rateTableId, currencyId);
        }
    }

    private void setDefaultValue(int index, long rateTableId, long currencyId) {
        this.setDefaultRateTableId(index, rateTableId);
        this.setDefaultCurrency(index, currencyId);
        this.setDefaultLocCurrency(index, currencyId);
    }

    private void setDefaultRateTableId(int index, long rateTableId) {
        Object rateTable = this.getModel().getValue("exratetable", index);
        if (null == rateTable) {
            this.getModel().setValue("exratetable", (Object)rateTableId, index);
        }
    }

    private void setDefaultCurrency(int index, long currencyId) {
        Object currency = this.getModel().getValue("currency", index);
        if (null == currency) {
            this.getModel().setValue("currency", (Object)currencyId, index);
        }
    }

    private void setDefaultLocCurrency(int index, long currencyId) {
        this.getModel().setValue("loccurr", (Object)currencyId, index);
    }

    private long getDefaultRateTableId() {
        if (!this.isExistsData("org")) {
            return 0L;
        }
        DynamicObject dataObj = this.getView().getParentView().getModel().getDataEntity();
        return SrcExchangeRateUtils.getRateTableIdByOrg((long)dataObj.getLong("org.id"));
    }

    private long getDefaultCurrencyId() {
        DynamicObject baseObj;
        if (!this.isExistsData("currency")) {
            return 0L;
        }
        DynamicObject dataObj = this.getView().getParentView().getModel().getDataEntity();
        long currencyId = dataObj.getLong("currency.id");
        if (currencyId == 0L && null != (baseObj = SrcAppCache.getOtherCompObjByCache((IFormView)this.getView(), null, (String)"src_project_base"))) {
            currencyId = baseObj.getLong("currency.id");
        }
        return currencyId;
    }

    private boolean isExistsData(String fieldName) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return false;
        }
        if (Objects.equals("ide_formdesigner", parentView.getEntityId())) {
            return false;
        }
        Control control = parentView.getControl(fieldName);
        return !Objects.isNull(control);
    }
}

