/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.LowTimer;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcDecisionUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcPurlistAssEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private List<String> reCalcFields = null;

    public void registerListener(EventObject e) {
        BasedataEdit bidMaterialEdit;
        BasedataEdit baseDataEditCategory;
        super.registerListener(e);
        BasedataEdit baseDataEditMaterial = (BasedataEdit)this.getView().getControl("material");
        if (null != baseDataEditMaterial) {
            baseDataEditMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (baseDataEditCategory = (BasedataEdit)this.getView().getControl("category"))) {
            baseDataEditCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (bidMaterialEdit = (BasedataEdit)this.getView().getControl("bidmaterial"))) {
            bidMaterialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            bidMaterialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (Objects.equals(parentView.getEntityId(), "src_purlist")) {
            this.setBidMaterial2PageCache(parentView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LowTimer timer = new LowTimer();
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String entityId = parentView.getEntityId();
            boolean isQuote = true;
            if ("tnd_tenderbill".equals(entityId)) {
                boolean bl = isQuote = parentView.getModel().getDataEntity().getInt("number") == 0 || parentView.getModel().getDataEntity().getBoolean("isquote");
            }
            if ("src_bidpublish".equals(entityId) || !isQuote) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
            } else if ("src_decision".equals(entityId)) {
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                int i = 0;
                for (DynamicObject row : rows) {
                    if (Objects.equals("3", row.getString("result"))) {
                        this.getModel().setValue("orderratio", (Object)0, i);
                    }
                    ++i;
                }
            }
        }
        this.getModel().setDataChanged(false);
        SrcBidOpenFacade.hideSupplierName((IFormView)this.getView(), (long)PdsCommonUtils.object2Long((Object)this.getModel().getValue("parentid")));
        BizLog.log((String)("###SrcPurlistAssEdit afterbinddata costtime:" + timer.msValue()));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String entityId;
        super.propertyChanged(args);
        IDataModel model = this.getModel();
        String fieldKey = args.getProperty().getName();
        Object obj = args.getChangeSet()[0].getNewValue();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (null != obj) {
            int changeRow = args.getChangeSet()[0].getRowIndex();
            switch (fieldKey) {
                case "material": {
                    DynamicObject materialObj = (DynamicObject)obj;
                    model.setValue("category", Optional.ofNullable(materialObj.getDynamicObject("group")).map(DataEntityBase::getPkValue).orElse(null), changeRow);
                    model.setValue("materialmodel", (Object)materialObj.getString("modelnum"), changeRow);
                    model.setValue("materialnane", (Object)materialObj.getString("name"), changeRow);
                    break;
                }
                case "unit": {
                    PdsCommonUtils.setScaleByUnit((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)obj), (BigDecimal)((BigDecimal)this.getModel().getValue("qty", changeRow)), (String)"qty", (int)changeRow);
                    break;
                }
                case "cfmqty": 
                case "orderratio": {
                    SrcPurListUtil.purlistEntryEditHandle((IFormView)this.getView(), (int)changeRow, (String)fieldKey, (PropertyChangedArgs)args);
                    break;
                }
            }
        }
        if ((Objects.equals(entityId = parentView.getEntityId(), "src_decision") || Objects.equals(entityId, "src_predecision")) && "entryentity".equals(args.getProperty().getParent().getName())) {
            if (null == this.reCalcFields) {
                this.reCalcFields = PdsCommonUtils.getPropertiesFromFieldMapper((String)"SYS017", null, null);
            }
            if (null != this.reCalcFields && this.reCalcFields.contains("entryentity." + fieldKey)) {
                SrcDecisionUtil.clearSumTaxAmount((IFormView)this.getView());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        int index = beforeF7SelectEvent.getRow();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        if ("src_purlist".equals(entityId)) {
            String key = beforeF7SelectEvent.getProperty().getName();
            DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            switch (key) {
                case "material": {
                    break;
                }
                case "category": {
                    Set categoryIds = SrcPurListUtil.getCategoryIds((DynamicObject)dataEntity);
                    if (categoryIds.size() <= 0) break;
                    formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)categoryIds));
                    break;
                }
                case "bidmaterial": {
                    List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)parentView.getModel().getDataEntity(), (boolean)false);
                    HashSet itemIds = new HashSet(16);
                    for (String compKey : compKeyList) {
                        itemIds.addAll(PdsCommonUtils.getPageCache((IPageCache)parentView.getPageCache(), (String)("prepurlistcache" + compKey)));
                    }
                    QFilter qFilter = SrcPurListUtil.getBidMaterialFilter((DynamicObject)parentView.getModel().getDataEntity(true), null);
                    if (!CollectionUtils.isEmpty(itemIds)) {
                        DynamicObject bidObj;
                        DynamicObject col = this.getModel().getEntryRowEntity("entryentity", index);
                        if (Objects.nonNull(col) && Objects.nonNull(bidObj = col.getDynamicObject("bidmaterial"))) {
                            itemIds.remove(bidObj.getPkValue());
                        }
                        qFilter.and(new QFilter("id", "not in", itemIds));
                    }
                    formShowParameter.getListFilterParameter().setFilter(qFilter);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperation) {
        super.beforeDoOperation(beforeDoOperation);
        String opKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String entityId = parentView.getEntityId();
        block3 : switch (opKey) {
            case "submit": {
                switch (entityId) {
                    case "src_project": 
                    case "src_purlist": {
                        this.setSrcBillNoValue(parentView);
                        break block3;
                    }
                    case "src_decision": {
                        SrcPurListUtil.validatorMaterialNaneSupplier((DynamicObjectCollection)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
                        break block3;
                    }
                }
            }
        }
    }

    private void setSrcBillNoValue(IFormView parentView) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < rows.size(); ++i) {
            if (!Objects.equals(((DynamicObject)rows.get(i)).getString("reqsource"), "4")) continue;
            this.getModel().setValue("srcbillno", parentView.getModel().getDataEntity().get("billno"), i);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String fieldKey = ((FieldEdit)afterF7SelectEvent.getSource()).getFieldKey();
        if (Objects.equals("bidmaterial", fieldKey)) {
            this.setBidMaterial2PageCache(parentView);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String fieldName = e.getEntryProp().getName();
        if ("entryentity".equals(fieldName)) {
            this.setBidMaterial2PageCache(parentView);
            if (Objects.equals(parentView.getEntityId(), "src_project")) {
                parentView.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().sendFormAction(parentView);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        String fieldName = e.getEntryProp().getName();
        if ("entryentity".equals(fieldName) && Objects.equals(parentView.getEntityId(), "src_project")) {
            parentView.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().sendFormAction(parentView);
        }
    }

    private void setBidMaterial2PageCache(IFormView parentView) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        Set bidIds = rows.stream().map(obj -> obj.getDynamicObject("bidmaterial")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(PdsCommonUtils::object2Long).collect(Collectors.toSet());
        PdsCommonUtils.setPageCache((IPageCache)parentView.getPageCache(), (String)("prepurlistcache" + this.getView().getEntityId()), bidIds);
    }
}

