/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcRetenderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tenderid = (BasedataEdit)this.getView().getControl("tenderid");
        tenderid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (Objects.isNull(parentView)) {
            return;
        }
        DynamicObject obj = parentView.getModel().getDataEntity();
        if (Objects.equals(obj.getString("billstatus"), SrcProjectEnum.STAGING.getCode())) {
            this.getModel().setValue("stopbiddate", (Object)obj.getDate("project.stopbiddate"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "tenderid": {
                long projectId = this.getModel().getDataEntity().getLong("projectf7.id");
                QFilter qfilter = new QFilter("project", "=", (Object)projectId);
                qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qfilter);
                break;
            }
        }
    }
}

