/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.util.SrcScoreBySupUtil;

public class SrcScoreBySupPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_ENTRYENTITY = "score_entry";
    private volatile boolean isChanging;
    private FormShowParameter param;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.param = (FormShowParameter)e.getSource();
        EntryAp entryAp = this.createDynamicEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", KEY_ENTRYENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("scoretype", PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"scoretype"));
        this.getModel().setValue("project", PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"projectid"));
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setEventObj(e);
        SrcScoreBySupUtil.excuteExtPlugin((ExtPluginContext)context, (String)"ISrcScoreBySupLoadData");
        SrcScoreBySupUtil.excuteExtPlugin((ExtPluginContext)context, (String)"ISrcScoreInitSupData");
    }

    public void beforeBindData(EventObject e) {
        EntryAp dynamicEntryAp = this.createDynamicEntryAp();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        if (SrcScoreFacade.isEvaluateScore((String)this.getView().getEntityId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"package", "indextype"});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        LinkedHashMap<String, String> supMap;
        String[] keys = e.getKey().split("_");
        if (keys.length == 2 && null != (supMap = this.getSupMap()).get(keys[1])) {
            FieldEdit fieldEdit = new FieldEdit();
            if ("prefixtext".equals(keys[0])) {
                fieldEdit = new TextEdit();
            }
            fieldEdit.setKey(e.getKey());
            fieldEdit.setEntryKey(KEY_ENTRYENTITY);
            fieldEdit.setEntryControlKey(KEY_ENTRYENTITY);
            fieldEdit.setView(this.getView());
            fieldEdit.setModel(this.getModel());
            e.setControl((Control)fieldEdit);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        if (!this.isChanging) {
            this.isChanging = true;
            ExtPluginContext context = new ExtPluginContext();
            context.setView(this.getView());
            context.setPropertyChangeArgs(evt);
            context.setVerifyOk(false);
            SrcScoreBySupUtil.excuteExtPlugin((ExtPluginContext)context, (String)"ISrcScoreBySupProChange");
            this.isChanging = false;
        }
    }

    private EntryAp createDynamicEntryAp() {
        FormMetadata meta = PdsMetadataUtil.getFormMetaData((String)"src_scorebysupplier");
        EntryAp entryAp = new EntryAp();
        for (ControlAp ap : meta.getItems()) {
            if (!(ap instanceof EntryAp)) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        LinkedHashMap<String, String> supMap = this.getSupMap();
        for (Map.Entry<String, String> sup : supMap.entrySet()) {
            String cbFiledText = SrcScoreBySupUtil.getCheckBoxKey((String)sup.getKey());
            CheckBoxField cbField = new CheckBoxField();
            cbField.setId(cbFiledText);
            cbField.setKey(cbFiledText);
            cbField.setDefValue(false);
            EntryFieldAp fieldAp2 = new EntryFieldAp();
            fieldAp2.setId(cbFiledText);
            fieldAp2.setKey(cbFiledText);
            fieldAp2.setName(new LocaleString(this.getFiledName((Field<?>)cbField, sup.getValue())));
            fieldAp2.setFireUpdEvt(true);
            fieldAp2.setField((Field)cbField);
            entryAp.getItems().add(fieldAp2);
            String filedText = SrcScoreBySupUtil.getTextKey((String)sup.getKey());
            TextField field = new TextField();
            field.setId(filedText);
            field.setKey(filedText);
            field.setEditStyle(2);
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(filedText);
            fieldAp.setKey(filedText);
            fieldAp.setName(new LocaleString(this.getFiledName((Field<?>)field, sup.getValue())));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setField((Field)field);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYENTITY);
        LinkedHashMap<String, String> supMap = this.getSupMap();
        for (Map.Entry<String, String> sup : supMap.entrySet()) {
            String cbFiledText = SrcScoreBySupUtil.getCheckBoxKey((String)sup.getKey());
            BooleanProp checkbox = new BooleanProp();
            checkbox.setName(cbFiledText);
            checkbox.setDisplayName(new LocaleString());
            checkbox.setDbIgnore(true);
            checkbox.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)checkbox);
            String filedText = SrcScoreBySupUtil.getTextKey((String)sup.getKey());
            TextProp textProp2 = new TextProp();
            textProp2.setName(filedText);
            textProp2.setDisplayName(new LocaleString());
            textProp2.setDbIgnore(true);
            textProp2.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp2);
        }
    }

    private String getFiledName(Field<?> prop, String name) {
        if (prop instanceof CheckBoxField) {
            return name;
        }
        if (prop instanceof TextField) {
            return name;
        }
        return name;
    }

    private LinkedHashMap<String, String> getSupMap() {
        LinkedHashMap supMap = new LinkedHashMap(32);
        IFormView view = this.getView();
        if (null == this.param && null != view) {
            this.param = view.getFormShowParameter();
        }
        if (null == this.param) {
            return new LinkedHashMap<String, String>();
        }
        Object supObject = this.param.getCustomParam("supplier");
        if (supObject instanceof LinkedHashMap) {
            supMap = (LinkedHashMap)supObject;
        } else {
            supMap.putAll((Map)supObject);
        }
        return supMap;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        context.setAfterDoOperationEventArgs(afterDoOperationEventArgs);
        SrcScoreBySupUtil.excuteExtPlugin((ExtPluginContext)context, (String)"ISrcScoreBySupOpHandle");
    }
}

