/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcClarifyUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.src.common.util.SrcBidAssessUtils;
import kd.scm.src.common.util.SrcComponentUtil;

public class SrcScorerTaskEdit
extends PdsBillCompTplEdit {
    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        if (null == this.getModel().getValue("template")) {
            TemplateUtil.setDefaultTemplate((IDataModel)this.getModel(), (String)PdsBizNodeEnums.SCORERTASK.getValue());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (evt.isCancel()) {
            return;
        }
        String key = evt.getItemKey();
        long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        switch (key) {
            case "bar_allopen": {
                IFormView compView = SrcComponentUtil.getComponentView((IFormView)this.getView(), (String)"src_bidopen_open");
                if (!Objects.nonNull(compView)) break;
                compView.invokeOperation("save");
                break;
            }
            case "notify": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u901a\u77e5\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5229\u76ca\u5173\u7cfb\u6f84\u6e05\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SrcScorerTaskEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("notify"));
                evt.setCancel(true);
                break;
            }
            case "todotask": {
                QFilter qFilter = new QFilter("project", "=", (Object)billId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_memberclarify", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String key;
        super.beforeDoOperation(evt);
        switch (key = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "bidresult": {
                SrcBidAssessUtils.openBidAssessResult((IFormView)this.getView());
                break;
            }
            case "purlist": {
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                qFilter.and("supplier", ">", (Object)0);
                qFilter.and("entrystatus", ">", (Object)ProjectStatusEnums.TOQUOTE.getValue());
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_supplierpurlist", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEvt) {
        super.afterDoOperation(afterDoOperationEvt);
        String opKey = afterDoOperationEvt.getOperateKey();
        OperationResult result = afterDoOperationEvt.getOperationResult();
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        switch (opKey) {
            case "scorehelper": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("project", projectId);
                }
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_scoreassist", (ShowType)ShowType.MainNewTabPage, paramMap, null);
                break;
            }
            case "scoreanalyse": {
                if (!result.isSuccess()) break;
                if (projectId > 0L) {
                    paramMap.put("projectids", PdsCommonUtils.buildSet((Long[])new Long[]{projectId}));
                    OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scoreanalyse", (ShowType)ShowType.MainNewTabPage, null, null, null);
                    break;
                }
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_scoreanalyse", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "confirm": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "reject": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unsubmit": 
            case "unaudit": {
                if (!result.isSuccess()) break;
                this.deleteBidassess(projectId);
                break;
            }
            case "recalculate": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "aptitude": {
                OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_aptitudeaudit", (Object)this.getModel().getDataEntity().getPkValue(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"src_question", (boolean)true);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "close": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void deleteBidassess(long projectId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_bidassess_biz", (QFilter[])new QFilter[]{qFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "notify": {
                if (evt.getResult() != MessageBoxResult.Yes) {
                    return;
                }
                long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                if (projectId == 0L) {
                    return;
                }
                Map notifyMap = SrcClarifyUtils.notifyAllMember((IFormView)this.getView(), (long)projectId, (String)"src_project_man");
                if (((Boolean)notifyMap.get("succed")).booleanValue()) {
                    this.getView().showSuccessNotification(notifyMap.get("message").toString());
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showTipNotification(notifyMap.get("message").toString());
                break;
            }
        }
    }
}

