/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.pds.common.noticetpl.IPdsNoticeInterface;
import kd.scm.pds.common.noticetpl.PdsNoticeTplContext;
import kd.scm.pds.common.noticetpl.PdsNoticeTplFactory;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class SrcSourceNoticeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String REFRESHCONTENT = "refreshcontent";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit noticeTpl = (BasedataEdit)this.getControl("noticetpl");
        noticeTpl.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void afterCreateNewData(EventObject e) {
        String supscope = this.getModel().getValue("supscope").toString();
        this.supScopeChanged(supscope);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(" ");
        this.getModel().setValue("content", (Object)"");
        this.getModel().setValue("duedate", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object content = this.getModel().getValue("content");
        if (Objects.nonNull(content)) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            richTextEditor.setText(content.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                String text = richTextEditor.getText();
                model.setValue("content", (Object)text);
                break;
            }
            case "refreshcontent": {
                RichTextEditor richText = (RichTextEditor)this.getControl("richtexteditorap");
                String contents = this.getContent();
                richText.setText(contents);
                this.getModel().setValue("content", (Object)contents);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"SrcSourceNoticeEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public static void supplierChangedHandle(IDataModel model, PropertyChangedArgs e) {
        ChangeData[] change = e.getChangeSet();
        if (change[0] == null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)change[0].getNewValue();
        if (null == supplier) {
            return;
        }
        int index = change[0].getRowIndex();
        DynamicObject loadSup = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (String)supplier.getDynamicObjectType().getName());
        HashMap supMap = PdsLinkManFacade.getSupplierLinkMan((DynamicObject)loadSup);
        model.setValue("supcontacter", supMap.get("linkman"), index);
        model.setValue("supphone", supMap.get("phone"), index);
        model.setValue("supemail", supMap.get("email"), index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "supplier": {
                SrcSourceNoticeEdit.supplierChangedHandle(this.getModel(), e);
                break;
            }
            case "supscope": {
                this.supScopeChanged(newValue.toString());
                break;
            }
            case "biztype": {
                this.getModel().setValue("noticetpl", null);
                break;
            }
            case "noticetpl": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("content", null);
                    richTextEditor.setText(null);
                    break;
                }
                String contents = this.getContent();
                richTextEditor.setText(contents);
                this.getModel().setValue("content", (Object)contents);
                break;
            }
        }
    }

    private String getContent() {
        Object tpl = this.getModel().getValue("noticetpl");
        if (null == tpl) {
            return "";
        }
        long srcbillid = PdsCommonUtils.object2Long((Object)this.getModel().getValue("srcbillid"));
        if (srcbillid == 0L) {
            srcbillid = PdsCommonUtils.object2Long((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue());
        }
        DynamicObject srcBillObj = BusinessDataServiceHelper.loadSingle((Object)srcbillid, (String)"src_project");
        PdsNoticeTplContext noticeContext = new PdsNoticeTplContext((DynamicObject)tpl, srcBillObj);
        IPdsNoticeInterface pdsNoticePlugin = PdsNoticeTplFactory.getPdsNoticePluginInstance((PdsNoticeTplContext)noticeContext);
        String contents = pdsNoticePlugin.decorateContent(noticeContext);
        return contents;
    }

    public void supScopeChanged(String str) {
        switch (str) {
            case "3": 
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pl_supinfo"});
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"pl_supinfo"});
                break;
            }
        }
        this.getView().updateView("pl_supinfo");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("supplier".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("groupStandard", (Object)BillAssistConstant.GROUP_STANDARD_ID);
            showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
        } else if ("noticetpl".equals(fieldKey)) {
            Object bizType = this.getModel().getValue("biztype");
            if (null == bizType || StringUtils.isEmpty((String)String.valueOf(bizType))) {
                beforeF7SelectEvent.setCancel(true);
                Control bizTypeControl = this.getControl("biztype");
                String bizTypeName = PdsMetadataUtil.getFieldDisplayName((Control)bizTypeControl);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%1$s\u3002", (String)"SrcSourceNoticeEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]), bizTypeName));
            } else {
                QFilter customQFilter = new QFilter("biztype", "=", (Object)" ");
                customQFilter.or("biztype", "=", bizType);
                beforeF7SelectEvent.addCustomQFilter(customQFilter);
            }
        }
    }
}

