/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.bizop.PdsBizOperateLogUtils;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcSubmitSuggestionEdit
extends AbstractFormPlugin
implements UploadListener {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.setDefaultValue();
        this.createEntry();
        this.setEnable();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBillAttachment();
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        if (!this.isExistsScoringTask()) {
            return;
        }
        if ("0".equals(PdsCommonUtils.object2String((Object)this.getPageCache().get("operationsubmit"), (String)"0")) && SrcScoreHelper.isNeedSuggestion((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("project.id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u9700\u8981\u63d0\u4ea4\u8bc4\u5ba1\u610f\u89c1\uff0c\u8bf7\u70b9\u201c\u63d0\u4ea4\u201d\u6309\u94ae\u3002", (String)"SrcSubmitSuggestionEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void setDefaultValue() {
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        String baseType = this.getBaseType(paramMap);
        Object project = paramMap.get("project");
        if (null != project) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"project", "basetype"});
        } else {
            DynamicObjectCollection rows = parentView.getModel().getEntryEntity("score_entry");
            if (rows.size() > 0) {
                project = ((DynamicObject)rows.get(0)).get("bidbillid");
            }
        }
        this.getModel().setValue("project", project);
        this.getModel().setValue("basetype", (Object)baseType);
    }

    private String getBaseType(Map<String, Object> paramMap) {
        Object baseTypeObj = paramMap.get("basetype");
        String baseType = null;
        baseType = PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"4") ? "4" : (PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"7") ? "7" : (PdsCommonUtils.isEqualOrContain((Object)baseTypeObj, (String)"8") ? "8" : "1"));
        return baseType;
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "project": 
            case "basetype": {
                this.createEntry();
                this.setEnable();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null != result && result.isSuccess() && "submit".equals(args.getOperateKey())) {
            this.submitSuggestion();
            this.commitBillAttachment();
            this.recordBizOpLog();
            this.getPageCache().put("operationsubmit", "1");
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getView().close();
        }
    }

    private void submitSuggestion() {
        QFilter qfilters = this.getQFilter();
        if (null == qfilters) {
            return;
        }
        boolean isEvaluate = this.isEvaluate();
        String entityName = isEvaluate ? "src_evaluateopinionf7" : "src_scoresuggestionf7";
        Map<Long, List<DynamicObject>> scorerMap = this.getScorerMap(qfilters);
        Map<Long, DynamicObject> suggestionMap = this.getSuggestionMap(qfilters);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        ArrayList<DynamicObject> suggestionList = new ArrayList<DynamicObject>(rows.size());
        ArrayList<DynamicObject> newSuggestionList = new ArrayList<DynamicObject>(rows.size());
        for (DynamicObject row : rows) {
            long billId = row.getLong("billid.id");
            DynamicObject suggestionObj = suggestionMap.get(billId);
            List<DynamicObject> scorerList = scorerMap.get(billId);
            if (null == suggestionObj) {
                suggestionObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                suggestionObj.set("scorer", (Object)scorerList.get(0).getLong("scorer.id"));
                suggestionObj.set("agent", (Object)scorerList.get(0).getLong("agent.id"));
                suggestionObj.set("billid", (Object)billId);
                newSuggestionList.add(suggestionObj);
            } else {
                suggestionList.add(suggestionObj);
            }
            suggestionObj.set("scorerscore", row.get("scorerscore"));
            suggestionObj.set("isvalid", row.get("isvalid"));
            if (isEvaluate) {
                suggestionObj.set("grade", row.get("grade"));
            }
            suggestionObj.set("suggestion", row.get("suggestion"));
            suggestionObj.set("attachment", row.get("attachment"));
        }
        PdsCommonUtils.saveDynamicObjects(suggestionList);
        PdsCommonUtils.saveDynamicObjects(newSuggestionList);
    }

    private void createEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        QFilter qfilters = this.getQFilter();
        if (null == qfilters) {
            return;
        }
        Map<Long, List<DynamicObject>> scorerMap = this.getScorerMap(qfilters);
        Map<Long, DynamicObject> suggestionMap = this.getSuggestionMap(qfilters);
        boolean isEvaluate = this.isEvaluate();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (Map.Entry<Long, List<DynamicObject>> entry : scorerMap.entrySet()) {
            String isValid;
            BigDecimal scorerScore = this.getSumScore(entry);
            BigDecimal minScore = entry.getValue().get(0).getBigDecimal("billid.minvalue");
            ts.set("billid", (Object)entry.getKey(), index);
            ts.set("scorerscore", (Object)scorerScore, index);
            DynamicObject suggestionObj = suggestionMap.get(entry.getKey());
            if (null != suggestionObj) {
                ts.set("isvalid", suggestionObj.get("isvalid"), index);
                ts.set("suggestion", suggestionObj.get("suggestion"), index);
                ts.set("attachment", suggestionObj.get("attachment"), index);
            }
            if ("0".equals(isValid = PdsCommonUtils.object2String((Object)ts.get("isvalid", index), (String)"0"))) {
                if (scorerScore.compareTo(minScore) >= 0) {
                    ts.set("isvalid", (Object)"1", index);
                } else {
                    ts.set("isvalid", (Object)"2", index);
                }
            }
            if (isEvaluate && null != suggestionObj) {
                ts.set("grade", suggestionObj.get("grade.id"), index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private void setEnable() {
        if (!this.isExistsScoringTask()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"isvalid"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"grade"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"suggestion"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"attachment"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"submit"});
            this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"isvalid"});
            this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"grade"});
            this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"suggestion"});
            this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"attachment"});
        }
    }

    private QFilter getScoringTaskFilter() {
        long projectId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("project_id"));
        if (projectId == 0L) {
            return null;
        }
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        qfilters.and("billstatus", "=", (Object)"A");
        return qfilters;
    }

    private boolean isExistsScoringTask() {
        IFormView pparentView;
        QFilter qfilters = this.getScoringTaskFilter();
        if (qfilters == null) {
            return false;
        }
        String entityName = null;
        IFormView parentView = this.getView().getParentView();
        if (null != parentView && null != (pparentView = parentView.getParentView())) {
            entityName = pparentView.getEntityId();
        }
        if (null == entityName || Objects.equals(entityName, "bos_list") || Objects.equals(entityName, "src_apphome") || Objects.equals(entityName, "wf_msg_center") || Objects.equals(entityName, "ide_formdesigner")) {
            String baseType;
            switch (baseType = PdsCommonUtils.object2String((Object)this.getModel().getValue("basetype"), (String)"1")) {
                case "4": {
                    entityName = "src_aptitudeaudit";
                    break;
                }
                case "7": {
                    entityName = "src_aptitudeaudit2";
                    break;
                }
                case "8": {
                    entityName = "src_expertevaluate";
                    break;
                }
                default: {
                    entityName = "src_scorertask";
                }
            }
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])qfilters.toArray());
    }

    private BigDecimal getSumScore(Map.Entry<Long, List<DynamicObject>> entry) {
        BigDecimal sumScore = BigDecimal.ZERO;
        for (DynamicObject obj : entry.getValue()) {
            sumScore = sumScore.add(obj.getBigDecimal("scorerscore"));
        }
        return sumScore;
    }

    private Map<Long, List<DynamicObject>> getScorerMap(QFilter qfilters) {
        String entityName = this.isEvaluate() ? "src_evaluatetask_scorerf7" : "src_scoretask_scorerf7";
        Map<Long, List<DynamicObject>> scorerMap = new HashMap<Long, List<DynamicObject>>();
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"billid.id,billid.minvalue,scorerscore,scorer.id,agent.id", (QFilter[])qfilters.toArray());
        if (rows.size() > 0) {
            scorerMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("billid.id")));
        }
        return scorerMap;
    }

    private Map<Long, DynamicObject> getSuggestionMap(QFilter qfilters) {
        String entityName = this.isEvaluate() ? "src_evaluateopinionf7" : "src_scoresuggestionf7";
        Map<Long, DynamicObject> suggestionMap = new HashMap<Long, DynamicObject>();
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.length > 0) {
            suggestionMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("billid.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        }
        return suggestionMap;
    }

    private QFilter getQFilter() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        Object project = model.getValue("project");
        String baseType = PdsCommonUtils.object2String((Object)model.getValue("basetype"), (String)"1");
        if (project == null) {
            return null;
        }
        Set scoreTaskIds = null;
        if (null != PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"scoretask")) {
            scoreTaskIds = PdsCommonUtils.object2Set((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"scoretask"));
        }
        QFilter qfilters = new QFilter("billid.project", "=", (Object)((DynamicObject)project).getLong("id"));
        qfilters.and("billid.bizstatus", "!=", (Object)"E");
        qfilters.and(new QFilter("scorer", "=", (Object)RequestContext.get().getCurrUserId()).or("agent", "=", (Object)RequestContext.get().getCurrUserId()));
        if (baseType.equals("7")) {
            qfilters.and("billid.isaptitude2", "=", (Object)"1");
        } else if (baseType.equals("4")) {
            qfilters.and("billid.isaptitude", "=", (Object)"1");
            qfilters.and("billid.isaptitude2", "=", (Object)"0");
        } else if (!baseType.equals("8")) {
            qfilters.and("billid.isaptitude", "=", (Object)"0");
            qfilters.and("billid.isaptitude2", "=", (Object)"0");
            if (SrcBidAssessUtils.isNeedExcludeBizIndex((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"))) {
                qfilters.and("billid.indextype.basetype", "!=", (Object)"2");
            }
        }
        if (null != scoreTaskIds && scoreTaskIds.size() > 0) {
            qfilters.and("billid", "in", (Object)scoreTaskIds);
        }
        return qfilters;
    }

    private void setBillAttachment() {
        String entityName = this.isEvaluate() ? "src_evaluateopinion" : "src_scoresuggestion";
        List attachments = AttachmentServiceHelper.getAttachments((String)entityName, (Object)SrcScoreHelper.getBillId((IFormView)this.getView()), (String)"attachmentpanel", (boolean)false);
        if (null == attachments || attachments.size() == 0) {
            return;
        }
        ArrayList<Map> allAttachments = new ArrayList<Map>(attachments.size());
        for (Map attachment : attachments) {
            String creator = PdsCommonUtils.object2String(attachment.get("creator"), (String)"");
            if (!creator.equals(RequestContext.get().getUserName())) continue;
            allAttachments.add(attachment);
        }
        if (null != allAttachments && allAttachments.size() > 0) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
            attachmentPanel.bindData(allAttachments);
        }
    }

    protected void commitBillAttachment() {
        String entityName = this.isEvaluate() ? "src_evaluateopinion" : "src_scoresuggestion";
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List attachments = attachmentPanel.getAttachmentData();
        if (null == attachments || attachments.size() == 0) {
            return;
        }
        AttachmentUtils.convertTempAttachments((List)attachments);
        AttachmentServiceHelper.upload((String)entityName, (Object)SrcScoreHelper.getBillId((IFormView)this.getView()), (String)"attachmentpanel", (List)attachments);
    }

    public void afterRemove(UploadEvent evt) {
        String entityName = this.isEvaluate() ? "src_evaluateopinion" : "src_scoresuggestion";
        ArrayList<String> fileNames = new ArrayList<String>(8);
        for (Object url : evt.getUrls()) {
            fileNames.add((String)((Map)url).get("name"));
        }
        QFilter qfilters = new QFilter("finterid", "=", (Object)SrcScoreHelper.getBillId((IFormView)this.getView()));
        qfilters.and("fattachmentpanel", "=", (Object)"attachmentpanel");
        qfilters.and("fbilltype", "=", (Object)entityName);
        qfilters.and("fattachmentname", "in", fileNames);
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qfilters.toArray());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void recordBizOpLog() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        long projectId = this.getModel().getDataEntity().getLong("project.id");
        paramMap.put("project", projectId);
        paramMap.put("billid", projectId);
        paramMap.put("entitykey", this.getView().getEntityId());
        String basetType = this.getModel().getDataEntity().getString("basetype");
        paramMap.put("opkey", basetType);
        String opName = ComboEditUtils.getComboKeyByValue((DynamicObject)this.getModel().getDataEntity(), (String)"basetype", (String)basetType);
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"SrcSubmitSuggestionEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0])).append(opName).append(ResManager.loadKDString((String)"\u610f\u89c1", (String)"SrcSubmitSuggestionEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        paramMap.put("optype", sb.toString());
        String description = ResManager.loadKDString((String)"\u8bc4\u59d4\u63d0\u4ea4\u8bc4\u6807/\u8d44\u5ba1\u610f\u89c1\u3002", (String)"SrcSubmitSuggestionEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]);
        paramMap.put("reason", description);
        PdsBizOperateLogUtils.recordBizOpLog(paramMap);
    }

    public boolean isEvaluate() {
        return "8".equals(this.getModel().getDataEntity().getString("basetype"));
    }
}

