/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;

public class SrcSupplierBatchInvite
extends AbstractBillPlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "batch": {
                this.batchInvite();
                break;
            }
        }
    }

    private void batchInvite() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject billObj = parentView.getModel().getDataEntity();
        if (billObj != null) {
            paramMap.put("project", billObj.getPkValue());
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batch");
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_supplier_batch", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)closeCallBack);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"batch")) {
            this.batchCreateEntry(evt);
        }
    }

    private void batchCreateEntry(ClosedCallBackEvent evt) {
        DynamicObjectCollection rows = (DynamicObjectCollection)evt.getReturnData();
        if (rows == null || rows.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int index = model.getEntryRowCount("entrysupplier");
        for (DynamicObject row : rows) {
            Set packagIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"package");
            Set supplierIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"supplier");
            Iterator iterator = packagIds.iterator();
            while (iterator.hasNext()) {
                long packageId = (Long)iterator.next();
                Iterator iterator2 = supplierIds.iterator();
                while (iterator2.hasNext()) {
                    long supplierId = (Long)iterator2.next();
                    model.createNewEntryRow("entrysupplier");
                    model.setValue("package", (Object)packageId, index);
                    model.setValue("suppliertype", (Object)"bd_supplier", index);
                    model.setValue("supplier", (Object)supplierId, index);
                    model.setValue("note", (Object)row.getString("note"), index);
                    ++index;
                }
            }
        }
    }
}

