/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsParameterUtils;

public class SrcSurplusInitPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject eventobject) {
        Set fieldNameSet;
        super.beforeBindData(eventobject);
        FeeManageUtils.setSurplusFieldVisibleEdit((IFormView)this.getView());
        this.setDefaultValue();
        if (this.getModel().getValue("createorg") == null) {
            this.getModel().setValue("createorg", (Object)PdsCommonUtils.getPurchaseOrg());
        }
        if (this.getModel().getValue("org") == null && (fieldNameSet = PdsParameterUtils.getSurplusFieldSet()).contains("org")) {
            this.getModel().setValue("org", this.getModel().getValue("createorg"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                try (TXHandle tx = TX.requiresNew();){
                    Set fieldNameSet = PdsParameterUtils.getSurplusFieldSet();
                    if (fieldNameSet.contains("org")) {
                        this.getModel().setValue("createorg", this.getModel().getValue("org"));
                    }
                    FeeManageUtils.createPaymentEntryInit((IDataModel)this.getModel());
                }
                PdsCommonUtils.refreshParentView((IFormView)this.getView());
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        switch (keyName = e.getProperty().getName()) {
            case "supplier": 
            case "org": 
            case "feeitem": 
            case "source": 
            case "currency": 
            case "surplustype": 
            case "createorg": {
                String billId = FeeManageUtils.buildSurplusBillNo((IDataModel)this.getModel());
                this.getModel().setValue("presurplusamount", (Object)FeeManageUtils.getSurplusAmount((String)billId));
                break;
            }
        }
    }

    private void setDefaultValue() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map dataMap = parameter.getCustomParams();
        if (null == dataMap || dataMap.size() == 0) {
            return;
        }
        long billId = PdsCommonUtils.object2Long(dataMap.get("id"));
        if (billId == 0L) {
            return;
        }
        DynamicObject surplusObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"src_feesurplus");
        if (null == surplusObj) {
            return;
        }
        this.getModel().setValue("suppliertype", (Object)"bd_supplier");
        this.getModel().setValue("supplier", (Object)surplusObj.getLong("supplier.id"));
        this.getModel().setValue("org", (Object)surplusObj.getLong("org.id"));
        this.getModel().setValue("currency", (Object)surplusObj.getLong("currency.id"));
        this.getModel().setValue("feeitem", (Object)surplusObj.getLong("feeitem.id"));
        this.getModel().setValue("source", (Object)surplusObj.getLong("source.id"));
        this.getModel().setValue("presurplusamount", (Object)surplusObj.getBigDecimal("surplusamount"));
        this.getModel().setValue("createorg", (Object)surplusObj.getLong("createorg.id"));
        this.getModel().setValue("surplustype", (Object)surplusObj.getString("surplustype"));
    }

    public void registerListener(EventObject e) {
        BasedataEdit createOrgEdit;
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((createOrgEdit = (BasedataEdit)this.getView().getControl("createorg")) != null) {
            createOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals("org") || evt.getProperty().getName().equals("createorg")) {
            PdsParameterUtils.setPermOrgFilter((BeforeF7SelectEvent)evt, (String)"src_feesurplus");
            return;
        }
    }
}

