/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;

public class SrcQuestiomFilterByBizType
implements IExtFilterPlugin<ExtFilterContext> {
    private static final long serialVersionUID = 1L;

    public Map<String, Object> getQFilter(ExtFilterContext context) {
        Map qfilterMap = FilterGridUtils.getQFilter((String)"pds_extfilter", (String)"src_question");
        if (qfilterMap.isEmpty()) {
            return null;
        }
        QFilter qfilter = (QFilter)qfilterMap.get("qfilter");
        if (null == qfilter) {
            return null;
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_question", (String)"id,project.id,questype", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return null;
        }
        Set<Long> projectIds = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        Set<String> myTaskSet = this.getMyTaskBiztypeSet(this.getMyTaskIds(projectIds));
        if (myTaskSet.size() == 0) {
            return null;
        }
        HashSet<Long> questionIds = new HashSet<Long>(rows.size());
        for (DynamicObject row : rows) {
            String key = row.getString("project.id") + '_' + row.getString("questype");
            if (!myTaskSet.contains(key)) continue;
            questionIds.add(row.getLong("id"));
        }
        QFilter questionFilter = new QFilter("id", "in", questionIds);
        return this.getQFilterMap(questionFilter, null);
    }

    private Set<String> getMyTaskBiztypeSet(Set<Long> myTaskIds) {
        if (myTaskIds.size() == 0) {
            return Collections.emptySet();
        }
        QFilter qfilters = new QFilter("entryid", "in", myTaskIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_member_biztype", (String)"entryid.project.id,biztype.paramvalue", (QFilter[])qfilters.toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getString("entryid.project.id") + '_' + e.getString("biztype.paramvalue")).collect(Collectors.toSet());
    }

    private Set<Long> getMyTaskIds(Set<Long> projectIds) {
        QFilter projectFilter = new QFilter("project", "in", projectIds);
        long userId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("bidder", "=", (Object)userId);
        userFilter.or("project.creator", "=", (Object)userId);
        userFilter.or("creator", "=", (Object)userId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"id", (QFilter[])projectFilter.and(userFilter).toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }
}

