/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.negotiate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.src.common.util.SrcNegotiateUtil;
import kd.scm.src.formplugin.negotiate.SrcNegotiateAddNegBill;
import kd.scm.src.formplugin.negotiate.SrcNegotiateFacade;

public class SrcCreateNegotiateService
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.verifyStatus(context);
        if (!context.isSucced() || context.getBillId() > 0L) {
            return;
        }
        this.prepareData(context);
        if (!context.isSucced()) {
            return;
        }
        this.createNegBill(context);
    }

    public void verifyStatus(ExtPluginContext context) {
        QFilter negFilter;
        DynamicObject negBillObj;
        QFilter qfilter = new QFilter("id", "=", (Object)context.getProjectId());
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"openstatus", (QFilter[])qfilter.toArray());
        String openStatus = projectObj.getString("openstatus");
        if (BidOpenStatusEnums.BIZOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.OPEN.getValue().equals(openStatus)) {
            return;
        }
        if (BidOpenStatusEnums.NEGOTIATE.getValue().equals(openStatus) && null != (negBillObj = SrcNegotiateUtil.getQuoteBill((String)"src_negotiatebill", (QFilter)(negFilter = new QFilter("project", "=", (Object)context.getProjectId())))) && !negBillObj.getBoolean("isquotebidopen")) {
            context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)negBillObj));
            return;
        }
        context.setSucced(false);
        context.setMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5f00\u5546\u52a1\u6807\u6216\u5df2\u5168\u90e8\u5f00\u6807\u7684\u5bfb\u6e90\u9879\u76ee\uff0c\u624d\u5141\u8bb8\u53d1\u8d77\u8bae\u4ef7\u3002", (String)"SrcCreateNegotiateService_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
    }

    public void prepareData(ExtPluginContext context) {
        String selectFields;
        DynamicObject[] rows;
        if (null != context.getObjsMap() && context.getObjsMap().size() > 0) {
            return;
        }
        QFilter purlistFilter = new QFilter("project", "=", (Object)context.getProjectId());
        purlistFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        Set<Long> purlistIds = null;
        QFilter qfilter = SrcNegotiateFacade.getNegExtFilter(context.getProjectId());
        if (null != qfilter) {
            purlistIds = SrcNegotiateFacade.getNegExtFilterPurlistIds(qfilter);
        }
        if (null != purlistIds && purlistIds.size() > 0) {
            purlistFilter.and("id", "in", purlistIds);
        }
        if (null == (rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)(selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false)), (QFilter[])purlistFilter.toArray())) || rows.length == 0) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u62a5\u4ef7\u5355\u5206\u5f55\uff0c\u65e0\u6cd5\u521b\u5efa\u8bae\u4ef7\u5355\u3002", (String)"SrcCreateNegotiateService_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, List<DynamicObject>> purlistMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("compkey.number")));
        context.setObjsMap(purlistMap);
    }

    public void createNegBill(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcNegotiateAddNegBill.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcNegotiateAddNegBill.class.getName());
    }
}

