/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.negotiate;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcNegotiateUtil;

public class SrcNegotiateAddNegBill
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.addNegBill(context);
    }

    protected void addNegBill(ExtPluginContext context) {
        this.createNegotiateBill(context);
        if (context.isSucced()) {
            SrcBidOpenFacade.setProjectOpenStatus((long)context.getProjectId());
            if (null != context.getView()) {
                context.getView().setVisible(Boolean.TRUE, new String[]{"viewnegbill"});
            }
            context.setMessage(ResManager.loadKDString((String)"\u6dfb\u52a0\u8bae\u4ef7\u6210\u529f", (String)"SrcNegotiateAddNegBill_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void createNegotiateBill(ExtPluginContext context) {
        String billId = "";
        String turns = "";
        String formId = "src_negotiatebill";
        String pkValue = String.valueOf(context.getProjectId());
        StringBuilder errorMessage = new StringBuilder();
        DynamicObject multiquotebill = null;
        Map selectData = null == context.getObjsMap() || context.getObjsMap().size() == 0 ? SrcNegotiateUtil.getQuoteData((IFormView)context.getView()) : context.getObjsMap();
        QFilter qfilter = new QFilter("project.id", "=", (Object)context.getProjectId()).and("isreplenish", "=", (Object)"0");
        multiquotebill = SrcNegotiateUtil.getQuoteBill((String)formId, (QFilter)qfilter);
        if (multiquotebill != null) {
            billId = multiquotebill.getString("id");
            String bizstatus = multiquotebill.getString("bizstatus");
            String billstatus = multiquotebill.getString("billstatus");
            Date deadline = multiquotebill.getDate("deadline");
            boolean isDead = false;
            if (deadline == null || TimeServiceHelper.now().after(deadline)) {
                // empty if block
            }
            if (StringUtils.equals((CharSequence)bizstatus, (CharSequence)BillStatusEnum.AUDIT.getVal()) || StringUtils.equals((CharSequence)bizstatus, (CharSequence)BillStatusEnum.CLOSED.getVal()) || isDead) {
                turns = multiquotebill.getString("turns");
                billId = SrcNegotiateUtil.createNegotiateBill((DynamicObject)multiquotebill, (Map)selectData, (String)formId, (String)pkValue, (String)turns, (StringBuilder)errorMessage);
            } else {
                String negotiateType = multiquotebill.getString("negotiatetype");
                if ((SrcNegotiatetypeEnums.OFFLINE_PURLIST.getValue().equals(negotiateType) || SrcNegotiatetypeEnums.OFFLINE_PACKAGE.getValue().equals(negotiateType)) && StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
                    turns = multiquotebill.getString("turns");
                    billId = SrcNegotiateUtil.createNegotiateBill((DynamicObject)multiquotebill, (Map)selectData, (String)formId, (String)pkValue, (String)turns, (StringBuilder)errorMessage);
                } else {
                    SrcNegotiateUtil.setMultiquotecomdata((DynamicObject)multiquotebill, (Map)selectData);
                }
            }
        } else {
            billId = SrcNegotiateUtil.createNegotiateBill((DynamicObject)multiquotebill, (Map)selectData, (String)formId, (String)pkValue, (String)turns, (StringBuilder)errorMessage);
        }
        if (errorMessage.length() > 0) {
            this.getUnSuccedResult(context, errorMessage.toString());
        } else {
            context.setBillId(PdsCommonUtils.object2Long((Object)billId));
            if (null != context.getView()) {
                IPageCache pageCache = context.getView().getPageCache();
                pageCache.put("billid", billId);
            }
        }
    }
}

