/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.negotiate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcNegotiateUtil;

public class SrcNegotiateVerifyPurlistStatus
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.purlistVerify(context);
    }

    protected void purlistVerify(ExtPluginContext context) {
        IFormView view = context.getView();
        IDataModel model = view.getModel();
        if (null == model) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        StringBuilder sb = new StringBuilder();
        HashMap<String, Set<String>> negSrcEntryIdsMap = new HashMap<String, Set<String>>();
        int[] selectRows = entryGrid.getSelectRows();
        for (int i = 0; i < selectRows.length; ++i) {
            Set<String> negSrcEntryIds;
            String compKey;
            int index = selectRows[i];
            int seq = index + 1;
            String entryid = model.getValue("entryid", index).toString();
            long projectId = this.getProjectId(model, index);
            String packagename = this.getPackageName(model, index);
            String materialnane = model.getValue("materialnane", index).toString();
            String status = (String)model.getValue("entrystatus", index);
            if (!status.equals(ProjectStatusEnums.OPENED.getValue())) {
                sb = sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%1$s\u884c\u6807\u6bb5( %2$s ), \u6807\u7684( %3$s )\u72b6\u6001\u4e0d\u662f\u5df2\u5f00\u6807\u72b6\u6001\uff0c\u8bf7\u52ff\u6dfb\u52a0\u5230\u8bae\u4ef7\u5355\u3002", (String)"SrcNegotiateVerifyPurlistStatus_0", (String)"scm-src-formplugin", (Object[])new Object[0]), seq, packagename, materialnane)).append('\n');
                context.setSucced(false);
            }
            if (((Boolean)model.getValue("isdecision", index)).booleanValue()) {
                sb = sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%1$s\u884c\u6807\u6bb5( %2$s ), \u6807\u7684( %3$s )\u5df2\u7ecf\u5b9a\u6807\uff0c\u8bf7\u52ff\u6dfb\u52a0\u5230\u8bae\u4ef7\u5355\u3002", (String)"SrcNegotiateVerifyPurlistStatus_1", (String)"scm-src-formplugin", (Object[])new Object[0]), seq, packagename, materialnane)).append('\n');
                context.setSucced(false);
            }
            if ((compKey = this.getCompKey(model, index)) == null || null == (negSrcEntryIds = this.getNegSrcEntryIds(negSrcEntryIdsMap, projectId, compKey)) || negSrcEntryIds.size() == 0 || !negSrcEntryIds.contains(entryid)) continue;
            sb = sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c%1$s\u884c\u6807\u6bb5( %2$s ), \u6807\u7684( %3$s )\u5df2\u6dfb\u52a0\u5230\u8bae\u4ef7\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002\n\u8bf7\u901a\u8fc7\u201c\u67e5\u770b\u8bae\u4ef7\u5355\u201d\uff0c\u5bf9\u672a\u5b8c\u6210\u7684\u8bae\u4ef7\u5355\u8fdb\u884c\u5ba1\u6838\u6216\u5f00\u6807\u5904\u7406\u3002", (String)"SrcNegotiateVerifyPurlistStatus_5", (String)"scm-src-formplugin", (Object[])new Object[0]), seq, packagename, materialnane)).append('\n');
            context.setSucced(false);
        }
        context.setMessage(sb.toString());
    }

    private Set<String> getNegSrcEntryIds(Map<String, Set<String>> negSrcEntryIdsMap, long projectId, String compKey) {
        DynamicObject negCompObj;
        String mapKey = String.valueOf(projectId) + '|' + compKey;
        Set<String> negSrcEntryIds = negSrcEntryIdsMap.get(mapKey);
        if (null != negSrcEntryIds) {
            return negSrcEntryIds;
        }
        negSrcEntryIds = new HashSet<String>();
        QFilter filter = new QFilter("project", "=", (Object)projectId);
        filter.and("isquotebidopen", "=", (Object)false);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_negotiatebill", (boolean)true);
        DynamicObject[] negBillObjs = BusinessDataServiceHelper.load((String)"src_negotiatebill", (String)selectFields, (QFilter[])filter.toArray());
        DynamicObject negBillObj = SrcNegotiateUtil.getLastTurnsNegBill((DynamicObject[])negBillObjs);
        if (null != negBillObj && (negCompObj = TemplateUtil.getCompData((DynamicObject)negBillObj, (String)compKey)) != null) {
            DynamicObjectCollection negRows = negCompObj.getDynamicObjectCollection("entryentity");
            negSrcEntryIds = negRows.stream().map(e -> e.getString("srcentryid")).collect(Collectors.toSet());
        }
        negSrcEntryIdsMap.put(mapKey, negSrcEntryIds);
        return negSrcEntryIds;
    }

    private String getCompKey(IDataModel model, int index) {
        Object compkeyObj = model.getValue("compkey", index);
        String compkey = null;
        compkey = compkeyObj instanceof DynamicObject ? ((DynamicObject)compkeyObj).getString("number") : model.getValue("compkey", index).toString();
        if (compkey == null || compkey != null && compkey.trim().length() <= 0) {
            return null;
        }
        return compkey;
    }

    private long getProjectId(IDataModel model, int index) {
        DynamicObject projectObj = (DynamicObject)model.getValue("project", index);
        return projectObj.getLong("id");
    }

    private String getPackageName(IDataModel model, int index) {
        Object rowPackageObj = model.getValue("package", index);
        if (rowPackageObj instanceof DynamicObject) {
            return ((DynamicObject)rowPackageObj).getString("packagename");
        }
        return model.getValue("packagename", index).toString();
    }
}

